package com.edgec.browserbackend.browser.domain;

import com.edgec.browserbackend.browser.dto.OperationHistoryDto;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@Getter
@Setter
@NoArgsConstructor
@Document(collection = "operationhistory")
public class OperationHistory {
    @Id
    private String id;
    private String username;
    private String nickname;
    private String loginIp;
    private String loginPlace;
    private String operation;
    private long operationTime;
    private String administrator;
    private String shopBindIp;
    private String shopBindName;

    public OperationHistory(OperationHistoryDto operationHistoryDto) {
        if (operationHistoryDto.getAccount() != null) {
            this.username = operationHistoryDto.getAccount();
        }

        if (operationHistoryDto.getNickname() != null) {
            this.nickname = operationHistoryDto.getNickname();
        }

        if (operationHistoryDto.getLoginIp() != null) {
            this.loginIp = operationHistoryDto.getLoginIp();
        }

        if (operationHistoryDto.getLoginPlace() != null) {
            this.loginPlace = operationHistoryDto.getLoginPlace();
        }

        if (operationHistoryDto.getOperation() != null) {
            this.operation = operationHistoryDto.getOperation();
        }

        if (operationHistoryDto.getShopBindIp() != null) {
            this.shopBindIp = operationHistoryDto.getShopBindIp();
        }

        if (operationHistoryDto.getShopBindName() != null) {
            this.shopBindName = operationHistoryDto.getShopBindName();
        }

        if (operationHistoryDto.getOperationTime() != null) {
            DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime localDateTime = LocalDateTime.parse(operationHistoryDto.getOperationTime(), format);
            this.operationTime = localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
        }
    }
}
