package com.edgec.browserbackend.browser.service;

import com.edgec.browserbackend.browser.domain.ShopSummary;
import com.edgec.browserbackend.browser.dto.FavoriteUrl;
import com.edgec.browserbackend.browser.dto.ShopFilterDto;
import com.edgec.browserbackend.browser.dto.ShopPageResultDto;
import com.edgec.browserbackend.browser.dto.ShopResultDto;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

/**
 * 商铺操作
 *
 * @author JMW
 */
public interface ShopService {

    /**
     * 新增店铺操作
     *
     * @param username username
     * @param shopResultDto shopResultDto
     * @return id
     */
    String addShop(String username, ShopResultDto shopResultDto);

    /**
     * 批量新增店铺
     *
     * @param username username
     * @param file file
     * @return IDS
     * @throws IOException IOException
     */
    List<String> addShops(String username, MultipartFile file) throws IOException;

    String updateShop(String username, ShopResultDto shopResultDto);

    void deleteShop(String username, String shopId);

    void transferShop(String username, String shopId, String groupId);

    void assignShops(String username, List<String> shopIds, List<String> users);

    ShopResultDto queryShop(String username, String shopId);

    ShopPageResultDto getShopList(String username, String groupId, int page, int amount, ShopFilterDto shopFilterDto, String tag);

    ShopSummary getShopSummary(String username);

    List<String> getShopUsers(String username, String shopId);

    List<String> getBatchShopUsers(String username, List<String> shopIds);

    Integer dealDirtyData();

    String queryShopCookieById(String id);

    Integer deleteShopCookieById(String id);

    boolean saveFavoritesByShopId(String shopId, FavoriteUrl favoriteUrl);

    boolean deleteFavoritesByShopId(String shopId, FavoriteUrl favoriteUrl);

    List<FavoriteUrl> getFavoritesByShopId(String shopId);
}
