package com.edgec.browserbackend.browser.task;

import com.edgec.browserbackend.account.repository.AccountRepository;
import com.edgec.browserbackend.auth.repository.mongo.MongoOAuth2AccessTokenRepository;
import com.edgec.browserbackend.browser.domain.IpResource;
import com.edgec.browserbackend.browser.domain.IpType;
import com.edgec.browserbackend.browser.domain.ProxyConfig;
import com.edgec.browserbackend.browser.repository.IpResourceRepository;
import com.edgec.browserbackend.browser.repository.ProxyConfigRepository;
import com.edgec.browserbackend.browser.repository.SpecialLineRepository;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.time.Instant;
import java.util.List;

@Component
public class Set3proxyTask {

    private static final Logger log = LoggerFactory.getLogger(Set3proxyTask.class);

    @Autowired
    private AccountRepository accountRepository;

    @Autowired
    private MongoOAuth2AccessTokenRepository mongoOAuth2AccessTokenRepository;

    @Autowired
    private IpResourceRepository ipResourceRepository;

    @Autowired
    private SpecialLineRepository specialLineRepository;

    @Autowired
    private ProxyConfigRepository proxyConfigRepository;

    @Scheduled(cron = "0 0/2 * * * ?")
    public void set3proxy() {
        long nowtime = Instant.now().toEpochMilli();
//        List<String> tokenUsernames = mongoOAuth2AccessTokenRepository.findByCreatedAtGreaterThan(validTime).stream().map(MongoOAuth2AccessToken::getUsername).collect(Collectors.toList());
//        List<String> accountParents = accountRepository.findByNameIn(tokenUsernames).stream().map(x -> x.getParent() == null ? x.getName() : x.getParent()).distinct().collect(Collectors.toList());
//        List<IpResource> ipResources = ipResourceRepository.findByOwnerInAndSpecialLine(accountParents, true);
        List<IpResource> ipResources = ipResourceRepository.findBySpecialLineAndIsDeleted(true, false);
        File file = new File("3proxy_" + Instant.now().toEpochMilli());
        try {
            try {
                file.delete();
                file.createNewFile();
            } catch (Exception t1) {
                log.error(t1.getMessage(), t1);
            }

            FileWriter fileWriter = new FileWriter(file, true);
            BufferedWriter bw = new BufferedWriter(fileWriter);
            bw.write("daemon\nlog /var/log/3proxy.log D\nrotate 30\n");
            bw.write("maxconn 10000\n");
            bw.write("fakeresolve\n");
            bw.write("config /root/3proxy.cfg\n");
            bw.write("monitor /root/3proxy.cfg\n");
            bw.write("deny * * $/root/blacklist.cfg\n");

            for (IpResource ipResource : ipResources) {
                if (StringUtils.isNotBlank(ipResource.getAddr()))
                    bw.write("users \"" + ipResource.getProxyUsername() + ":CL:" + ipResource.getProxyPassword() + "\"\n");
                ipResource.setUsingSpecialLine(true);
            }

            bw.write("\nauth strong\n");
            a:
            for (IpResource ipResource : ipResources) {
                if (StringUtils.isNotBlank(ipResource.getAddr())) {
                    if (ipResource.getPort() == null || ipResource.getPort().size() == 0)
                        continue a;

                    bw.write("allow " + ipResource.getProxyUsername() + "\n");
                    if (ipResource.getIpType() != IpType.OWN) {
                        bw.write("parent 1000 http " + ipResource.getAddr() + " " +
                                (ipResource.getPort().size() > 1 ? ipResource.getPort().get(1) : ipResource.getPort().get(0)) + " fangguanlianbrowser " + ipResource.getPassword() + "\n");
                    } else {
                        bw.write("parent 1000 http " + ipResource.getAddr() + " " +
                                (ipResource.getPort().size() > 1 ? ipResource.getPort().get(1) : ipResource.getPort().get(0)) + " " + ipResource.getUsername() + " " + ipResource.getPassword() + "\n");

                    }
                }
            }
            bw.write("\nallow none\nproxy -p20004\nsocks -p20005\n");
            bw.flush();
            bw.close();
            log.info("成功写入文件");

            if (proxyConfigRepository.count() > 0) {
                ProxyConfig proxyConfig = proxyConfigRepository.findAll().get(0);
                if (nowtime < proxyConfig.getTimestamp()) {
                    file.delete();
                    return;
                } else {
                    proxyConfigRepository.updateProxy(file, nowtime);
                    file.delete();
                }
            } else {
                proxyConfigRepository.updateProxy(file, nowtime);
                file.delete();
            }

        } catch (Exception e) {
            log.error("出错了");
            log.error(e.getMessage(), e);
        }
    }

}
