package com.edgec.browserbackend.account.repository;

import com.edgec.browserbackend.account.domain.Account;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Update;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import static org.springframework.data.mongodb.core.query.Criteria.where;

public class AccountRepositoryCustomImpl implements AccountRepositoryCustom {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public List<String> findInName(String[] name) {

        MatchOperation match = Aggregation.match(where("_id").in(name));
        ProjectionOperation projection = Aggregation.project("phoneNumber").andExclude("_id");
        AggregationResults<Map> aggregate = mongoTemplate.aggregate(Aggregation.newAggregation(match, projection), Account.class, Map.class);

        if (aggregate.getMappedResults().size() == 0) {
            return Arrays.asList();
        }
        List<Map> map = aggregate.getMappedResults();
        List<String> accountTelephones = new ArrayList<>();
        map.forEach(m -> {
            accountTelephones.addAll(m.values());
        });
        return accountTelephones;
    }

    @Override
    public void updateRealNameAndIdCard(String username, String realName, String idCard) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("name").is(username));

        Update update = new Update();
        update.set("realName", realName).set("idCard", idCard);
        mongoTemplate.upsert(basicQuery, update, Account.class);
    }

    @Override
    public Account findByPromotion(String code) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("promotion.code").is(code).and("parent").exists(false));

        Account account = mongoTemplate.findOne(basicQuery, Account.class);
        if (account == null)
            return null;
        return account;
    }
}
