package com.edgec.browserbackend.account.service;

import com.edgec.browserbackend.account.domain.*;
import com.edgec.browserbackend.account.dto.BillQueryResultDto;
import com.edgec.browserbackend.account.dto.IpCountQueryResultDto;
import com.edgec.browserbackend.account.dto.PromotionQueryResultDto;
import com.edgec.browserbackend.browser.domain.IpResource;
import com.edgec.browserbackend.browser.dto.IpResourceDto;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.io.File;
import java.util.HashMap;
import java.util.List;

public interface AdministratorService {

    Administrator createAdministrator(Administrator administrator);

    Administrator updateAdministrator(String name, String string);

    List<Administrator> getAllAdministrator();

    void deleteAdministrator(String name);

    Account getAccountByName(String target);

    Account getAccountByPhoneNumber(String target);

    Account getAccountByEmail(String target);

    BillQueryResultDto getUserBillingByName(String name);

    Account unLockLockedAccount(String name, Account account);

    Account lockAbnormalAccount(String name, Account account);

    Page<Account> searchAllUserPage(Pageable pageable);

    Page<UserPrePaidBilling> searchAllUserBillingPage(int page, int year1, int month1, int year2, int month2);

    Page<Account> searchCreateAccountBetween(Pageable pageable, String strDate1, String strDate2, int isAuthorized);

    List<UserPrePaidBilling> getServiceFeeOwedUserInfo();

    List<CompanyEarningsDto> getCompanyEarningDetail(String stringdate);

    boolean getUserLockState(String name);

    void deleteUser(String username);

    UserBalance findUserBalance(String username);

    //迁移userbilling到userprepaidbilling
    boolean userbillingTransfer();

    void addPromotionCode(String username, String promotionCode);

    IpCountQueryResultDto queyrIpCount(String username);

    PromotionQueryResultDto queryPromotion(Pageable pageable, String username, String promotionCode, String strDate1, String strDate2);

    void addWhiteList(String website);

    File getProxyConfig();
}
