package com.edgec.browserbackend.browser.task;

import com.edgec.browserbackend.account.repository.AccountRepository;
import com.edgec.browserbackend.account.repository.CompanyAuthorizeRepository;
import com.edgec.browserbackend.auth.domain.mongo.MongoOAuth2AccessToken;
import com.edgec.browserbackend.auth.repository.mongo.MongoOAuth2AccessTokenRepository;
import com.edgec.browserbackend.browser.domain.IpResource;
import com.edgec.browserbackend.browser.domain.ProxyConfig;
import com.edgec.browserbackend.browser.domain.SpecialLine;
import com.edgec.browserbackend.browser.repository.IpResourceRepository;
import com.edgec.browserbackend.browser.repository.ProxyConfigRepository;
import com.edgec.browserbackend.browser.repository.SpecialLineRepository;
import net.javacrumbs.shedlock.core.SchedulerLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.io.*;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class Set3proxyTask {

    private static final Logger log = LoggerFactory.getLogger(Set3proxyTask.class);

    @Autowired
    private AccountRepository accountRepository;

    @Autowired
    private MongoOAuth2AccessTokenRepository mongoOAuth2AccessTokenRepository;

    @Autowired
    private IpResourceRepository ipResourceRepository;

    @Autowired
    private SpecialLineRepository specialLineRepository;

    @Autowired
    private ProxyConfigRepository proxyConfigRepository;

    @Scheduled(cron = "0 0/10 * * * ?")
    @SchedulerLock(name = "proxyTask", lockAtLeastFor = 60*1000*5, lockAtMostFor = 60*1000*9)
    public void set3proxy() {
        long validTime = Instant.now().minusSeconds(43200).toEpochMilli();
        if (proxyConfigRepository.count() > 0) {
            ProxyConfig proxyConfig = proxyConfigRepository.findAll().get(0);
            if (Instant.now().toEpochMilli() < proxyConfig.getTimestamp())
                return;
        }
        List<String> tokenUsernames = mongoOAuth2AccessTokenRepository.findByCreatedAtGreaterThan(validTime).stream().map(MongoOAuth2AccessToken::getUsername).collect(Collectors.toList());
        List<String> accountParents = accountRepository.findByNameIn(tokenUsernames).stream().map(x -> x.getParent() == null ? x.getName() : x.getParent()).distinct().collect(Collectors.toList());
        List<IpResource> ipResources = ipResourceRepository.findByOwnerInAndSpecialLine(accountParents, true);
//        List<IpResource> ipResources = ipResourceRepository.findBySpecialLine(true);
        File file = new File("3proxy " + Instant.now().toEpochMilli());
        SpecialLine specialLine = specialLineRepository.findAll().get(0);
        try {
            file.delete();
            file.createNewFile();

            FileWriter fileWriter =new FileWriter(file, true);
            BufferedWriter bw = new BufferedWriter(fileWriter);
            bw.write("daemon\nlog /var/log/3proxy.log D\nrotate 30\n");
            bw.write("config /root/3proxy.cfg\n");
            bw.write("monitor /root/3proxy.cfg\n");

            for (IpResource ipResource : ipResources) {
                if (StringUtils.isNotBlank(ipResource.getAddr()))
                    bw.write("users \"" + ipResource.getProxyUsername() + ":CL:" + ipResource.getProxyPassword() + "\"\n");
            }

            bw.write("\nauth strong\n");
            for (IpResource ipResource : ipResources) {
                if (StringUtils.isNotBlank(ipResource.getAddr())) {
                    bw.write("allow " + ipResource.getProxyUsername() + "\n");
                    bw.write("parent 1000 http " + ipResource.getAddr() + " " + ipResource.getPort().get(1) + " fangguanlianbrowser " + ipResource.getPassword() + "\n");
                }
            }
            bw.write("\nallow none\nproxy -p20004\nsocks -p20005\n");
            bw.flush();
            bw.close();
            log.info("成功写入文件");
            long nowtime = Instant.now().toEpochMilli();
            if (proxyConfigRepository.count() > 0) {
                ProxyConfig proxyConfig = proxyConfigRepository.findAll().get(0);
                if (nowtime < proxyConfig.getTimestamp()) {
                    file.delete();
                    return;
                } else {
                    proxyConfigRepository.updateProxy(file, nowtime);
                    file.delete();
                }
            } else {
                proxyConfigRepository.updateProxy(file, nowtime);
                file.delete();
            }
        } catch (Exception e) {
            log.error("出错了");
            log.error(e.getMessage());
        }
    }

}
