package com.edgec.browserbackend.account.service;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;


public class DataCacheManager {
    public static DataCacheManager INSTANCE = new DataCacheManager();
    private static final String DATA_CACHE = "dataCache";

    private static final String CREDENTIAL_CACHE = "credentialCache";

    private CacheManager singletonManager= null;
    private Cache dataCache= null;
    private Cache credentialCache = null;

    public static DataCacheManager getManager() {
        return INSTANCE;
    }

    private DataCacheManager() {
        singletonManager = CacheManager.create();
        dataCache =  new Cache(DATA_CACHE, 5000, false, false, 60*3000000, 60*3000000);
        singletonManager.addCache(dataCache);
        credentialCache = new Cache(CREDENTIAL_CACHE, 5000, false, false, 3600*24*30, 3600*24*30);
        singletonManager.addCache(credentialCache);
    }

    public Cache getCache() {
        return dataCache;
    }

    public Cache getCredentialCache() {
        return this.credentialCache;
    }

}
