package com.edgec.browserbackend.auth.domain;

import org.apache.commons.lang3.StringUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.ArrayList;
import java.util.List;

@Document(collection = "users")
public class User implements UserDetails {

    @Id
    private String username;

    private String password;

    private String email;

    private String phone;

    private String verificationCode;

    private boolean enabled = false;

    private List<GrantedAuthority> authorities = new ArrayList<>();

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getVerificationCode() {
        return verificationCode;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setAuthorities(List<GrantedAuthority> authorities) {
        this.authorities = authorities;
    }
    @Override
    public List<GrantedAuthority> getAuthorities() {
        return authorities;
    }

    @Override
    public boolean isAccountNonExpired() {
        return true;
    }

    @Override
    public boolean isAccountNonLocked() {
        return true;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return enabled;
    }

    public User(com.edgec.browserbackend.account.domain.User user) {
        if (StringUtils.isNotEmpty(user.getEmail()))
        setEmail(user.getEmail());
        setPassword(user.getPassword());
        setPhone(user.getPhone());
        if (StringUtils.isNotEmpty(user.getUsername()))
        setUsername(user.getUsername());
        setVerificationCode(user.getVerificationCode());
        setEnabled(user.isEnabled());
    }

    public User(){

    };
}
