package com.edgec.browserbackend.browser.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * 云平台订单表
 *
 * @Author: Chen
 * @Date: 2024/07/28
 */
@Getter
@Setter
@NoArgsConstructor
@Document(collection = "cloudPlatformOrder")
@JsonIgnoreProperties(ignoreUnknown = true)
public class CloudPlatformOrder {

    @Id
    private String id;

    private String owner;

    private String ipResourceId;//ip资源id

    private String regionId;

    private String platformOrderId;//云平台订单id

    private String platformType;//云平台类型

}
