package com.edgec.browserbackend.browser.domain;

import com.edgec.browserbackend.browser.dto.FavoriteUrl;
import com.edgec.browserbackend.browser.dto.ShopResultDto;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

@Getter
@Setter
@NoArgsConstructor
@Document(collection = "shop")
@JsonIgnoreProperties(ignoreUnknown = true)
public class Shop {

    /**
     * 商铺 id
     */
    @Id
    private String shopId;

    /**
     * 商铺名称
     */
    private String shopName;

    /**
     * 商铺拥有者，谁创建谁拥有
     */
    private String owner;

    /**
     * 商铺 id
     */
    private TransferStatus transferStatus;

    /**
     * 商铺url
     */
    private String shopUrl;

    /**
     * 商铺所在的平台
     */
    private String shopPlatform;

    /**
     * 商铺账号
     */
    private String shopAccount;

    /**
     * 商铺密码
     */
    private String shopPassword;

    /**
     * 商铺平台（操作系统 + 浏览器版本）
     */
    private String shopUA;

    /**
     * 商铺的 cookie 信息
     */
    private String shopCookie;

    /**
     * 商铺创建时间
     */
    private long createTime;

    private List<FavoriteUrl> favoritesUrls;

    /**
     * 创建店铺使用
     */
    public Shop of(ShopResultDto shopResultDto) {
        if (shopResultDto.getShopUrl() != null) {
            this.setShopUrl(shopResultDto.getShopUrl());
        }

        if (shopResultDto.getOwner() != null) {
            this.setOwner(shopResultDto.getOwner());
        }

        if (shopResultDto.getShopPlatform() != null) {
            this.setShopPlatform(shopResultDto.getShopPlatform());
        }

        if (shopResultDto.getShopName() != null) {
            this.setShopName(shopResultDto.getShopName());
        }

        if (shopResultDto.getTransferStatus() != null) {
            this.setTransferStatus(shopResultDto.getTransferStatus());
        }

        if (shopResultDto.getShopAccount() != null) {
            this.setShopAccount(shopResultDto.getShopAccount());
        }

        if (shopResultDto.getShopPassword() != null) {
            this.setShopPassword(shopResultDto.getShopPassword());
        }

        if (shopResultDto.getShopUA() != null) {
            this.setShopUA(shopResultDto.getShopUA());
        }

        if (shopResultDto.getShopCookie() != null) {
            this.setShopCookie(shopResultDto.getShopCookie());
        }

        if (shopResultDto.getCreateTime() != 0) {
            this.setCreateTime(shopResultDto.getCreateTime());
        }

        return this;
    }

    public Shop of(Shop shop) {
        if (shop.getShopUrl() != null)
            this.setShopUrl(shop.getShopUrl());
        if (shop.getOwner() != null)
            this.setOwner(shop.getOwner());
        if (shop.getShopPlatform() != null)
            this.setShopPlatform(shop.getShopPlatform());
        if (shop.getShopName() != null)
            this.setShopName(shop.getShopName());
        if (shop.getTransferStatus() != null)
            this.setTransferStatus(shop.getTransferStatus());
        if (shop.getShopAccount() != null)
            this.setShopAccount(shop.getShopAccount());
        if (shop.getShopPassword() != null)
            this.setShopPassword(shop.getShopPassword());
        if (shop.getShopUA() != null)
            this.setShopUA(shop.getShopUA());
        if (shop.getShopCookie() != null)
            this.setShopCookie(shop.getShopCookie());
        if (shop.getCreateTime() != 0)
            this.setCreateTime(shop.getCreateTime());

        return this;
    }
}
