package com.edgec.browserbackend.browser.task;

import com.edgec.browserbackend.account.domain.Account;
import com.edgec.browserbackend.account.domain.Promotion;
import com.edgec.browserbackend.account.domain.UserPrePaidBilling;
import com.edgec.browserbackend.account.repository.AccountRepository;
import com.edgec.browserbackend.account.repository.UserPrePaidBillingRepository;
import com.edgec.browserbackend.browser.repository.GlobalFieldRepository;
import net.javacrumbs.shedlock.core.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.YearMonth;
import java.util.Arrays;
import java.util.List;

@Component
public class PromotionTask {

    private static final Logger log = LoggerFactory.getLogger(PromotionTask.class);

    @Autowired
    private AccountRepository accountRepository;

    @Autowired
    private UserPrePaidBillingRepository userPrePaidBillingRepository;

    private GlobalFieldRepository globalFieldRepository;

    // TODO 2020年7月2号, 晚上11点，jim负责跟踪下

    @SchedulerLock(name = "countGift", lockAtLeastForString = "PT1H", lockAtMostForString = "PT2H")
    @Scheduled(cron = "0 0 1 1 * ?")
    public void countGift() {
        List<Account> accounts = accountRepository.findByParentIsNull();
        for (Account account : accounts) {
            // 1. 获取当前账户的邀请码信息
            String code = account.getPromotion().getCode();
            // 2. 获取被当前账户邀请的所有账户
            List<Account> promotes = accountRepository.findByPromotionCodeAndParentIsNull(code);
            double totalCommission = 0;
            double secondCommission = 0;
            // 3. 计算所有被当前账户邀请的账户上个月的消费信息，以及如果当前账户是销售账户则还需要计算销售账户的下下级账户的上个月消费信息
            for (Account promote : promotes) {
                // 3.1 获取被邀请的用户上个月的消费信息，todo 感觉这个地方最好加上支付状态
                List<UserPrePaidBilling> userPrePaidBillings = userPrePaidBillingRepository.findByAdministratorAndYearAndMonthAndPayMethodIn(
                        promote.getName(), YearMonth.now().minusMonths(1).getYear(), YearMonth.now().minusMonths(1).getMonthValue(), Arrays.asList(1, 2, 3)
                );
                // 3.2. 计算被邀请的用户上个月的总消费金额
                totalCommission += userPrePaidBillings.stream().mapToDouble(UserPrePaidBilling::getTotal).sum();

                // 3.3. 如果当前账户是本公司销售，则计算下下级用户（例如：销售人员A 邀请了 用户B，用户B 邀请了 其他用户，其他用户就是A的下下级用户）上个月总消费金额
                if (account.getPromotion().isSale() && promote.getParent() == null) {
                    // 获取下下级账户
                    List<Account> secondPromotes = accountRepository.findByPromotionCodeAndParentIsNull(promote.getPromotion().getCode());
                    if (secondPromotes != null && !secondPromotes.isEmpty()) {
                        for (Account secondPromote : secondPromotes) {
                            List<UserPrePaidBilling> userPrePaidBillings1 = userPrePaidBillingRepository.findByAdministratorAndYearAndMonthAndPayMethodIn(
                                    secondPromote.getName(), YearMonth.now().minusMonths(1).getYear(), YearMonth.now().minusMonths(1).getMonthValue(), Arrays.asList(1, 2, 3)
                            );
                            secondCommission += userPrePaidBillings1.stream().mapToDouble(UserPrePaidBilling::getTotal).sum();
                        }
                    }
                }
            }

            // 4. 封装当前账户的返佣相关信息（总消费、上月消费、当月礼金、总共未体现礼金）并保存
            Promotion promotion = account.getPromotion();
            promotion.setTotalCommission((int) (promotion.getTotalCommission() + totalCommission));
            promotion.setCommissionLastMonth((int) totalCommission);
            promotion.setGift(totalCommission * 0.08);
            /*if (account.getPromotion().isSale()) {
                promotion.setGift(totalCommission * 0.1 + secondCommission * 0.02);
            }*/

            if (account.getPromotion().isDistributor()) {
                promotion.setGift(totalCommission * globalFieldRepository.findAll().get(0).getDistributorRate().doubleValue());
            }

            promotion.setAllGift(promotion.getAllGift() + promotion.getGift());
            accountRepository.save(account);
        }

        log.info("End scheduled task：Scheduled.countGift...");
    }

    // @SchedulerLock：标识使用分布式锁。name：用来标注一个定时服务的名字，被用于写入数据库作为区分不同服务的标识
    @SchedulerLock(name = "countCommission", lockAtLeastForString = "PT1H", lockAtMostForString = "PT2H")
    @Scheduled(cron = "0 0 3 * * ?")
    public void countCommission() {
        log.info("Start scheduled task：Scheduled.countCommission...");
        List<Account> accounts = accountRepository.findByParentIsNull();
        for (Account account : accounts) {
            // 1. 获取被当前账户邀请的所有账户
            String code = account.getPromotion().getCode();
            List<Account> promotes = accountRepository.findByPromotionCodeAndParentIsNull(code);

            double totalCommission = 0;
            double secondCommission = 0;
            // 2. 计算所有被当前账户邀请的账户当月当前的消费信息，以及如果当前账户是销售账户则还需要计算销售账户的下下级账户的当月当前消费信息
            for (Account promote : promotes) {
                List<UserPrePaidBilling> userPrePaidBillings = userPrePaidBillingRepository.findByAdministratorAndYearAndMonthAndPayMethodIn(
                        promote.getName(), YearMonth.now().getYear(), YearMonth.now().getMonthValue(), Arrays.asList(1, 2, 3)
                );
                totalCommission += userPrePaidBillings.stream().mapToDouble(UserPrePaidBilling::getTotal).sum();
                if (account.getPromotion().isSale() && promote.getParent() == null) {
                    List<Account> secondPromotes = accountRepository.findByPromotionCodeAndParentIsNull(promote.getPromotion().getCode());
                    if (secondPromotes != null && secondPromotes.size() > 0) {
                        for (Account secondPromote : secondPromotes) {
                            List<UserPrePaidBilling> userPrePaidBillings1 = userPrePaidBillingRepository.findByAdministratorAndYearAndMonthAndPayMethodIn(
                                    secondPromote.getName(), YearMonth.now().getYear(), YearMonth.now().getMonthValue(), Arrays.asList(1, 2, 3)
                            );
                            secondCommission += userPrePaidBillings1.stream().mapToDouble(UserPrePaidBilling::getTotal).sum();
                        }
                    }
                }
            }

            // 3. 封装当前账户的返佣相关信息（当月当前的消费、当月当前的返佣）并保存
            Promotion promotion = account.getPromotion();
            promotion.setCommission((int) totalCommission);

            // 4. 不同角色的人给不同的提成
            promotion.setGift(totalCommission * 0.08);
            /*if (account.getPromotion().isSale()) {
                promotion.setGift(totalCommission * 0.1 + secondCommission * 0.02);
            }*/
            if (account.getPromotion().isDistributor()) {
                promotion.setGift(totalCommission * globalFieldRepository.findAll().get(0).getDistributorRate().doubleValue());
            }
            accountRepository.save(account);
        }
        log.info("End scheduled task：Scheduled.countCommission...");
    }
}
