package com.edgec.browserbackend.account.controller;


import com.edgec.browserbackend.account.domain.*;
import com.edgec.browserbackend.account.dto.BillQueryResultDto;
import com.edgec.browserbackend.account.dto.NoticeDto;
import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.account.dto.UserUsedDto;
import com.edgec.browserbackend.account.service.*;
import com.edgec.browserbackend.browser.ErrorCode.BrowserErrorCode;
import com.edgec.browserbackend.browser.domain.PayBack;
import com.edgec.browserbackend.browser.dto.IpListRequestDto;
import com.edgec.browserbackend.browser.service.ShopService;
import com.edgec.browserbackend.browser.service.TempService;
import com.edgec.browserbackend.common.auth.Securitys;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import com.edgec.browserbackend.common.utils.ResponseUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@RestController
@RequestMapping("/vpsadmin")
public class AdministratorController {

    private final Logger log = LoggerFactory.getLogger(getClass());


    static final String mykey = "adasdfasfasdcjdf23297sdfjsdhdk34fldhf343dfd34554fkfhf45cnvhe55";

    @Autowired
    private AdministratorService administratorService;
    @Autowired
    private UserRateService userRateService;

    @Autowired
    private MonthReportService monthReportService;

    @Autowired
    private PaymentService paymentService;

    @Autowired
    private UserLackMoneyService userLackMoneyService;

    @Autowired
    private UserPrePaidBillingService userPrePaidBillingService;

    @Autowired
    private AccountService accountService;

    @Autowired
    private TempService tempService;

    @Autowired
    private PayBackService payBackService;

    @Autowired
    private ShopService shopService;

    //--------------------------------ROOT用户操作--------------------------------------//
    //管理员注册tested
    @PreAuthorize(Securitys.ROOT_EL)
    @RequestMapping(path = "/0xadministrator", method = RequestMethod.POST)
    public Administrator createNewAdministrator(@Valid @RequestBody Administrator administrator) {
        return administratorService.createAdministrator(administrator);
    }

    //删除管理员testing
    @PreAuthorize(Securitys.ROOT_EL)
    @RequestMapping(path = "/0xadministrator/{name}", method = RequestMethod.DELETE)
    public void deleteAdmin(@PathVariable String name) {
        administratorService.deleteAdministrator(name);
    }


    //  查询所有的管理员
    @PreAuthorize(Securitys.ROOT_EL)
    @RequestMapping(path = "/0xadministrator", method = RequestMethod.GET)
    public List<Administrator> getALLAdministrator() {
        return administratorService.getAllAdministrator();
    }


    //修改管理员权限tested
    @PreAuthorize(Securitys.ROOT_EL)
    @RequestMapping(path = "/0xadministrator/{name}", method = RequestMethod.PUT)
    public Administrator updateAgencyInfo(@PathVariable String name, @Valid @RequestBody String string) {
        return administratorService.updateAdministrator(name, string);
    }

    //用户通过银行转账，手动插入余额记录
    @PreAuthorize(Securitys.ROOT_EL)
    @RequestMapping(path = "/0xadministrator/banktransfer", method = RequestMethod.POST)
    public HashMap bankTransferInsert(@RequestBody UserBalance userBalance) {
        HashMap<String, Object> map = new HashMap<>();
        try {
            map.put("userbalance", paymentService.bankTransferInsertion(userBalance.getUsername(), (int) userBalance.getBalanced(), 3));
            map.put("status", "success");
        } catch (Exception e) {
            map.put("status", "failed");
        }
        return map;
    }

    //--------------------------------用户--------------------------------------//
    //根据用户的性名，或者电话，或者邮件，查询用户的信息tested
    @PreAuthorize("hasRole('ADMIN')")
    @RequestMapping(path = "/0xadministrator/searchuser/{target}", method = RequestMethod.GET)
    public Account getAccountByTarget(@RequestParam("by") String by, @PathVariable String target) {
        Account searchAccount = new Account();

        if ("name".equals(by)) {
            searchAccount = administratorService.getAccountByName(target);
        } else if ("phoneNumber".equals(by)) {
            searchAccount = administratorService.getAccountByPhoneNumber(target);
        } else if ("email".equals(by)) {
            searchAccount = administratorService.getAccountByEmail(target);
        }

        return searchAccount;

    }

    //根据用户名查询用户账单tested
    @PreAuthorize("hasRole('ADMIN')")
    @RequestMapping(path = "/0xadministrator/searchuserbill/{name}", method = RequestMethod.GET)
    public BillQueryResultDto getUserBillByName(@PathVariable String name, @RequestParam("page") int page, @RequestParam("size") int size) {
        return administratorService.getUserBillingByName(name);
    }


    //给用户激活未激活或者被锁住的账户tested
    @PreAuthorize("hasRole('ADMIN')")
    @RequestMapping(path = "/0xadministrator/unlockaccount/{name}", method = RequestMethod.PUT)
    public Account unLockAccount(@PathVariable String name, @Valid @RequestBody Account account) {
        return administratorService.unLockLockedAccount(name, account);
    }


    //锁住异常用户tested
    @PreAuthorize("hasRole('ADMIN')")
    @RequestMapping(path = "/0xadministrator/lockaccount/{name}", method = RequestMethod.PUT)
    public Account lockAccount(@PathVariable String name, @Valid @RequestBody Account account) {
        return administratorService.lockAbnormalAccount(name, account);
    }

    //查询用户余额
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/finduserbalance", method = RequestMethod.GET)
    public UserBalance findUserBlanceByName(@RequestParam(value = "username") String username) {
        return administratorService.findUserBalance(username);
    }

    // 查询所有已欠费用户
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/findlackmoney", method = RequestMethod.GET)
    public List<UserLackMoney> findAllUserLackMoney() {
        return userLackMoneyService.findAll();
    }

    // 手动刷新用户未支付订单，欠费状态
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/refreshbilling", method = RequestMethod.POST)
    public void refreshUserBillingAndCost(@RequestParam(value = "username") String username) {
        userPrePaidBillingService.refreshUserBillingStatus(username);
    }

    // 查询用户当前所有欠费账单
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/unpaidbilling/{username}", method = RequestMethod.GET)
    public List<UserPrePaidBilling> findUnpaidUserBilling(@PathVariable String username) {
        return userPrePaidBillingService.findUserBillingByUnpaid(username, BillStatus.UNPAID);
    }


    //--------------------------------系统--------------------------------------//
    //查询某时段内用户的账单，tested
    @PreAuthorize("hasRole('ADMIN')")
    @RequestMapping(path = "/0xadministrator/searchusers", method = RequestMethod.GET)
    public Page<UserPrePaidBilling> searchAllUserBilling(@RequestParam(value = "page") int page, @RequestParam(value = "year1") int year1, @RequestParam(value = "month1") int month1, @RequestParam(value = "year2") int year2, @RequestParam(value = "month2") int month2) {
        return administratorService.searchAllUserBillingPage(page, year1, year2, month1, month2);
    }

    //查看所有的用户<分页查询> tested
    @PreAuthorize("hasRole('ADMIN')")
    @RequestMapping(path = "/0xadministrator/searchalluser", method = RequestMethod.GET)
    public Page<Account> searchAllUser(@RequestParam(value = "page") int page, @RequestParam(value = "size") int size) {//(@PathVariable int  page){
        Pageable pageable = PageRequest.of(page, size);
        return administratorService.searchAllUserPage(pageable);
    }

    //查询某时段内增加的用户
    @PreAuthorize("hasRole('ADMIN')")
    @RequestMapping(path = "/0xadministrator/searchperioduser", method = RequestMethod.GET)
    public Page<Account> searchCreateAccount(@RequestParam(value = "page") int page, @RequestParam(value = "size") int size, @RequestParam(value = "strDate1") String strDate1, @RequestParam(value = "strDate2") String strDate2, @RequestParam(value = "isAuthorized", defaultValue = "5") int isAuthorized) {
        Pageable pageable = PageRequest.of(page, size);
        return administratorService.searchCreateAccountBetween(pageable, strDate1, strDate2, isAuthorized);
    }

    // 查询所有用户消费
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/allused", method = RequestMethod.GET)
    public Page<UserUsedDto> findAllused(@RequestParam(value = "page") int page, @RequestParam(value = "size") int size) {
        Pageable pageable = PageRequest.of(page, size);
        return administratorService.getAllUserUsed(pageable);
    }

    //search company earnings detail by month  tested
    @PreAuthorize("hasRole('ADMIN')")
    @RequestMapping(path = "/0xadministrator/companyearning/{stringdate}", method = RequestMethod.GET)
    public List<CompanyEarningsDto> getCompanyEarning(@PathVariable String stringdate) {
        return administratorService.getCompanyEarningDetail(stringdate);
    }


    //search information of service-fee owed users   tested
    @PreAuthorize("hasRole('ADMIN')")
    @RequestMapping(path = "/0xadministrator/oweduser", method = RequestMethod.GET)
    public List<UserPrePaidBilling> getOwedUser() {
        return administratorService.getServiceFeeOwedUserInfo();
    }


    //查找某个用户或者代理有没有被锁住
    @PreAuthorize("hasRole('ADMIN')")
    @RequestMapping(path = "/0xadministrator/lockstate/{name}", method = RequestMethod.GET)
    public boolean getLockState(@PathVariable String name) {
        return administratorService.getUserLockState(name);
    }


    //对欠费用户强制停机


    /**
     * 用户费率
     */

    // 设置费率
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/updateuserrate/{id}/{money}", method = RequestMethod.PUT)
    public boolean setUserRate(@PathVariable String id, @PathVariable float money) {
        userRateService.updateUserRate(id, money);
        return true;
    }

    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/adduserrate", method = RequestMethod.POST)
    public void insertUserRate(@RequestBody UserRate userRate) {
        userRateService.addUserRate(userRate);
    }

    // 查询用户费率
    @RequestMapping(path = "/0xadministrator/searchcurrentuserrate", method = RequestMethod.GET)
    public List<UserRate> getUserRate(@RequestParam String username) {
        return userRateService.getUserRate(username);
    }

    // 分页查询用户费率
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/searchalluserrate", method = RequestMethod.GET)
    public Page<UserRate> getUserRatePage(@RequestParam(value = "pageNo", defaultValue = "0") Integer pageNo,
                                          @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize) {
        PageRequest page = PageRequest.of(pageNo, pageSize);
        return userRateService.getUserRatePage(page);
    }

    // 删除用户费率
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/deleteuserrate/{id}", method = RequestMethod.DELETE)
    public boolean deleteUserRate(@PathVariable String id) {
        return userRateService.deleteUserRate(id);
    }


    // 注销用户
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/deleteUser", method = RequestMethod.DELETE)
    public void deleteUser(@RequestParam String username) {
        administratorService.deleteUser(username);
    }


    //每月预付费统计分页展示
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/listReport", method = RequestMethod.GET)
    public Page<CompanyMonthReport> listMonthReport(@RequestParam(value = "page", defaultValue = "0") int page,
                                                    @RequestParam(value = "size", defaultValue = "10") int size) {

        Pageable pageable = PageRequest.of(page, size);
        return monthReportService.listMonthReport(pageable);
    }

    // 迁移userbilling到userprepaidbilling
    @PreAuthorize(Securitys.ROOT_EL)
    @RequestMapping(path = "/0xadministrator/userbillingtransfer", method = RequestMethod.PUT)
    public boolean userbillingTransfer() {
        return administratorService.userbillingTransfer();
    }


    //获取用户企业认证的图片
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/authorize/files", method = RequestMethod.GET)
    public ResultDto getAuthorizeFiles(Principal principal, @RequestParam("username") String username, HttpServletResponse response) {
        ResultDto resultDto = new ResultDto();
        try {
            File tempFile = accountService.getAuthorizeFiles(username);
            try (OutputStream os = response.getOutputStream();
                 FileInputStream fis = new FileInputStream(tempFile)) {

                response.setHeader("content-type", "application/octet-stream");
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("Licenses.zip", "UTF-8"));
                int len = 0;
                byte[] bt = new byte[5 * 1024];
                while ((len = fis.read(bt)) != -1) {
                    os.write(bt, 0, len);
                }

            } catch (Exception e) {
                e.printStackTrace();
                throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
            } finally {
                tempFile.delete();
            }
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    //获取用户企业认证的信息
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/authorize/details", method = RequestMethod.GET)
    public ResultDto getAuthorizeDetails(Principal principal, @RequestParam("username") String username) {
        ResultDto resultDto = new ResultDto();
        try {
            resultDto.setData(accountService.getAuthorizeDetails(username));
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    //设置用户企业认证的信息
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/authorize/set", method = RequestMethod.PUT)
    public ResultDto setAuthorize(Principal principal, @RequestParam("username") String username, @RequestParam("isAgree") boolean isAgree) {
        ResultDto resultDto = new ResultDto();
        try {
            resultDto.setData(accountService.setAuthorize(username, isAgree));
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }


    //添加推广码
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/promotioncode/add", method = RequestMethod.PUT)
    public ResultDto addPromotionCode(Principal principal, @RequestParam("username") String username, @RequestParam("promotionCode") String promotionCode) {
        ResultDto resultDto = new ResultDto();
        try {
            administratorService.addPromotionCode(username, promotionCode);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    //添加白名单
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/whitelist/add", method = RequestMethod.PUT)
    public ResultDto addWhiteList(Principal principal, @RequestParam("website") String website) {
        ResultDto resultDto = new ResultDto();
        try {
            administratorService.addWhiteList(website);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    //添加白名单
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/userwhitelist/add", method = RequestMethod.PUT)
    public ResultDto addWhiteList(Principal principal, @RequestParam("username") String username, @RequestParam("website") String website) {
        ResultDto resultDto = new ResultDto();
        try {
            administratorService.addUserWhiteList(username, website);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    //统计ip数量
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/ip/count", method = RequestMethod.GET)
    public ResultDto getIpCount(Principal principal, @RequestParam(value = "username", defaultValue = "") String username) {
        ResultDto resultDto = new ResultDto();
        try {
            resultDto.setData(administratorService.queyrIpCount(username));
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    //统计推广码下消费
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/promotioncode/query", method = RequestMethod.GET)
    public ResultDto queryPromotion(Principal principal, @RequestParam(value = "page") int page, @RequestParam(value = "size") int size,
                                    @RequestParam(value = "strDate1") String strDate1, @RequestParam(value = "strDate2") String strDate2,
                                    @RequestParam(value = "username", required = false) String username, @RequestParam(value = "promotionCode", required = false) String promotionCode) {
        ResultDto resultDto = new ResultDto();
        try {
            long begin = System.currentTimeMillis();
            Pageable pageable = PageRequest.of(page, size);
            resultDto.setData(administratorService.queryPromotion(pageable, username, promotionCode, strDate1, strDate2));
            resultDto.setStatus(0);
            long end = System.currentTimeMillis();
            log.info("queryPromotion executed time: {} ms", (end - begin));
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    //统计推广码下消费
    @PreAuthorize(Securitys.ADMIN_EL)
    @GetMapping("/0xadministrator/promotioncode/queryinfo")
    public ResultDto queryCountPromotionInfo(@RequestParam(value = "strDate1") String strDate1, @RequestParam(value = "strDate2") String strDate2,
                                             @RequestParam(value = "username", required = false) String username, @RequestParam(value = "promotionCode", required = false) String promotionCode) {
        ResultDto resultDto = new ResultDto();
        try {
            long begin = System.currentTimeMillis();
            resultDto.setData(administratorService.countPromotionInfos(username, promotionCode, strDate1, strDate2));
            resultDto.setStatus(0);
            long end = System.currentTimeMillis();
            log.info("queryCountPromotionInfo executed time: {} ms", (end - begin));
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    //统计推广码下消费
    @PreAuthorize(Securitys.ADMIN_EL)
    @GetMapping("/0xadministrator/promotioncode/querypage")
    public ResultDto queryPagePromotionInfos(@RequestParam(value = "page") int page, @RequestParam(value = "size") int size,
                                             @RequestParam(value = "strDate1") String strDate1, @RequestParam(value = "strDate2") String strDate2,
                                             @RequestParam(value = "username", required = false) String username, @RequestParam(value = "promotionCode", required = false) String promotionCode) {
        ResultDto resultDto = new ResultDto();
        try {
            long begin = System.currentTimeMillis();
            Pageable pageable = PageRequest.of(page, size);
            resultDto.setData(administratorService.pagePromotionInfos(pageable, username, promotionCode, strDate1, strDate2));
            resultDto.setStatus(0);
            long end = System.currentTimeMillis();
            log.info("queryPagePromotionInfos executed time: {} ms", (end - begin));
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    //获取3proxy.cfg
    @RequestMapping(path = "/0xadministrator/getconfig", method = RequestMethod.GET)
    public void getProxyConfig(@RequestParam("key") String key, HttpServletResponse response) {
        File file = null;
        if (StringUtils.isNotBlank(key) && key.equals(mykey))
            file = administratorService.getProxyConfig();
        if (file != null) {
            try (OutputStream os = response.getOutputStream();
                 FileInputStream fis = new FileInputStream(file)) {

                response.setHeader("content-type", "application/octet-stream");
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("3proxy.cfg", "UTF-8"));
                int len = 0;
                byte[] bt = new byte[50 * 1024];
                while ((len = fis.read(bt)) != -1) {
                    os.write(bt, 0, len);
                }

            } catch (Exception e) {
                log.error(e.getMessage(), e);
                throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
            } finally {
                file.delete();
            }
        } else {
            log.error("file is empty");
        }

    }


    /**
     * 专线回落
     */
    @PreAuthorize(Securitys.ADMIN_EL)
    @PutMapping(value = "/0xadministrator/updateip/{addr}/{flag}")
    public ResultDto updateIp(@PathVariable String addr, @PathVariable String flag) {
        ResultDto resultDto = new ResultDto();
        try {
            tempService.saveIpResource(addr, flag);

            resultDto.setStatus(0);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            resultDto.setData(e.getMessage());
        }
        return resultDto;
    }

    /**
     * 设置客户为分销商
     */
    @PreAuthorize(Securitys.ADMIN_EL)
    @PutMapping(value = "/0xadministrator/account/{id}/{flag}")
    public ResultDto updateToDistributor(@PathVariable String id, @PathVariable Integer flag) {
        ResultDto resultDto = new ResultDto();
        try {
            boolean tag = false;
            if (flag == 1) {
                tag = true;
            }

            Long i = administratorService.convertToDistributor(id, tag);
            resultDto.setStatus(0);
            resultDto.setData(i);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            resultDto.setData(e.getMessage());
        }
        return resultDto;
    }

    /**
     * 获取用户IP列表
     *
     * @param owner owner
     * @return ResultDto
     */
    @PreAuthorize(Securitys.ADMIN_EL)
    @GetMapping(value = "/0xadministrator/{owner}/ip")
    public ResultDto ipMigration(@PathVariable String owner) {
        String logs = "【IpMigration】 ";
        log.info("{}, params : {}", logs, owner);
        try {
            return ResponseUtil.success(administratorService.getUsernameIpList(owner));
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            return ResponseUtil.error(e.getMessage());
        }
    }

    /**
     * 迁移ip
     *
     * @param owner    owner
     * @param newOwner newOwner
     * @param ips      ips
     * @return ResultDto
     */
    @PreAuthorize(Securitys.ADMIN_EL)
    @PutMapping(value = "/0xadministrator/{owner}/ip/{newOwner}")
    public ResultDto ipMigration(@PathVariable String owner, @PathVariable String newOwner, @RequestParam String ips) {
        String logs = "【IpMigration】 ";
        log.info("{}, params : {}, {} ip migration {}", logs, owner, newOwner, ips);
        try {
            return ResponseUtil.success(administratorService.ipMigration(owner, newOwner, ips));
        } catch (ClientRequestException e) {
            log.warn("{}, ClientRequestException : {}", logs, e.getErrorCode().getReason());
            return ResponseUtil.error(e.getErrorCode());
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            return ResponseUtil.error(e.getMessage());
        }
    }

    @PreAuthorize(Securitys.ADMIN_EL)
    @PostMapping(value = "/0xadministrator/payback")
    public List<PayBack> postBack(@RequestBody PayBack payBack) {
        return payBackService.createPayBack(payBack);
    }

    @PreAuthorize(Securitys.ADMIN_EL)
    @PutMapping(value = "/0xadministrator/payback")
    public List<PayBack> putBack(@RequestBody PayBack payBack) {
        return payBackService.updatePayBack(payBack);
    }

    @PreAuthorize(Securitys.ADMIN_EL)
    @DeleteMapping(value = "/0xadministrator/payback")
    public List<PayBack> deleteBack(Integer pay) {
        return payBackService.deletePayBack(pay);
    }

    /**
     * 设置公告
     */
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/setNotice", method = RequestMethod.POST)
    public boolean setNotice(@RequestBody Notice notice) {
        administratorService.setNotice(notice);
        return true;
    }

    /**
     * 查询公告
     */
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/getNotice", method = RequestMethod.GET)
    public NoticeDto getNotice() {
        return administratorService.getNotice();
    }

    /**
     * 删除公告
     */
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/delNotice", method = RequestMethod.DELETE)
    public boolean delNotice() {
        administratorService.delNotice();
        return true;
    }

    /**
     * 删除shopua
     */
    @PreAuthorize(Securitys.ADMIN_EL)
    @RequestMapping(path = "/0xadministrator/delShopUa/{uaflag}", method = RequestMethod.DELETE)
    public boolean delShopUa(@PathVariable String uaflag) {
        return shopService.delShopUa(uaflag);
    }
}












