package com.edgec.browserbackend.auth.service.security;

import com.edgec.browserbackend.auth.domain.User;
import com.edgec.browserbackend.auth.domain.UserAttemptsLogin;
import com.edgec.browserbackend.auth.exception.AuthErrorCode;
import com.edgec.browserbackend.auth.repository.UserAttemptsLoginRepository;
import com.edgec.browserbackend.auth.repository.UserRepository;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class AuthenticationFailureEventListener implements ApplicationListener<AuthenticationFailureBadCredentialsEvent> {

    private static final Logger log = LoggerFactory.getLogger(AuthenticationFailureEventListener.class);

    @Autowired
    private UserRepository userRepository;

    @Autowired
    private UserAttemptsLoginRepository userAttemptsLoginRepository;

    @Override
    public void onApplicationEvent(AuthenticationFailureBadCredentialsEvent authenticationFailureBadCredentialsEvent) {
        if (authenticationFailureBadCredentialsEvent.getAuthentication().getDetails() != null) {
            String username = authenticationFailureBadCredentialsEvent.getAuthentication().getPrincipal().toString();
            User user = userRepository.findById(username).orElse(null);
            if (user != null) {
                UserAttemptsLogin userAttempts = userAttemptsLoginRepository.findById(username).orElse(null);
                if (userAttempts != null) {
                    if (userAttempts.getDate().getTime() >= (new Date().getTime() - 600000)) {
                        int fails = userAttempts.getAttempts();
                        if (fails < 20)
                            saveUserAttemptsLogin(username, fails + 1);
                        else
                            throw new ClientRequestException(AuthErrorCode.LOGINTIMESEXCEEDED, "Login times exceeded");
                        return;
                    }
                }
                saveUserAttemptsLogin(username, 1);
            }
        }
    }

    public void saveUserAttemptsLogin(String username, int attempts) {
        // 因为此记录时间为最后一次登陆时间，所以UserAttempsLogin都是新构造的
        UserAttemptsLogin newUserAttempsLogin = new UserAttemptsLogin(username, attempts);
        userAttemptsLoginRepository.save(newUserAttempsLogin);
    }
}
