package com.edgec.browserbackend.browser.controller;

import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.browser.service.IpResourceService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import com.edgec.browserbackend.common.utils.ResponseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author jason
 */
@RestController
@RequestMapping("/config")
public class ConfigController {

    @Autowired
    private IpResourceService ipResourceService;

    private final Logger log = LoggerFactory.getLogger(ConfigController.class);

    /**
     * 获取ip配置选项
     *
     * @return ResultDto
     */
    @RequestMapping(value = "/ipOptions", method = RequestMethod.POST)
    public ResultDto getIpOptions() {
        String logs = "【getIpOptions】 ";
        try {
            return ResponseUtil.success(ipResourceService.getIpOptions());
        } catch (ClientRequestException e) {
            log.warn("{}, ClientRequestException : {}", logs, e.getErrorCode().getReason());
            return ResponseUtil.error(e.getErrorCode());
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            return ResponseUtil.error(e.getMessage());
        }
    }

    /**
     * todo--不知道
     *
     * @return ResultDto
     */
    @RequestMapping(value = "/setipOptions", method = RequestMethod.POST)
    public ResultDto setIpOptions() {
        String logs = "【setIpOptions】 ";
        try {
            ipResourceService.setIpOptions();
            return ResponseUtil.success();
        } catch (ClientRequestException e) {
            log.warn("{}, ClientRequestException : {}", logs, e.getErrorCode().getReason());
            return ResponseUtil.error(e.getErrorCode());
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            return ResponseUtil.error(e.getMessage());
        }
    }

    /**
     * 获取所属平台配置选项
     *
     * @return ResultDto
     */
    @RequestMapping(value = "/platformOptions", method = RequestMethod.POST)
    public ResultDto getPlatformOptions() {
        String logs = "【getPlatformOptions】 ";
        try {
            return ResponseUtil.success(ipResourceService.getPlatformOptions());
        } catch (ClientRequestException e) {
            log.warn("{}, ClientRequestException : {}", logs, e.getErrorCode().getReason());
            return ResponseUtil.error(e.getErrorCode());
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            return ResponseUtil.error(e.getMessage());
        }
    }
}
