package com.edgec.browserbackend.common.client;

import com.alibaba.fastjson.JSON;
import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.provider.StaticCredentialProvider;
import com.aliyun.sdk.service.ecs20140526.AsyncClient;
import com.aliyun.sdk.service.ecs20140526.models.DeleteInstanceRequest;
import com.aliyun.sdk.service.ecs20140526.models.DeleteInstanceResponse;
import com.aliyun.sdk.service.ecs20140526.models.DescribeInstancesRequest;
import com.aliyun.sdk.service.ecs20140526.models.DescribeInstancesResponse;
import com.aliyun.sdk.service.ecs20140526.models.RenewInstanceRequest;
import com.aliyun.sdk.service.ecs20140526.models.RenewInstanceResponse;
import com.aliyun.sdk.service.ecs20140526.models.RunInstancesRequest;
import com.aliyun.sdk.service.ecs20140526.models.RunInstancesResponse;
import com.edgec.browserbackend.browser.domain.CloudPlatformConfig;
import com.edgec.browserbackend.browser.repository.CloudPlatformConfigRepository;
import com.edgec.browserbackend.common.utils.Aes;
import darabonba.core.client.ClientOverrideConfiguration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @Description 阿里云ECS相关api \
 * url:https://next.api.aliyun.com/document/Ecs/2014-05-26/overview
 * @Data 2024年7月28日
 **/

@Service
@RequiredArgsConstructor
@Slf4j
public class AliEcsClient {


    private final CloudPlatformConfigRepository cloudPlatformConfigRepository;


    //access_key_id
    private static String getAccessKeyId() {
        return "LTAI5tEdz1DY4A4oYUawUuNH";
    }

    //access_key_secret
    private static String getAccessKeySecret() {
        return "8KWmYgO0QIicZpyulhEwUhZqStrTwe";
    }

    //launch_template_id

    //脚本userData
    private static String getUserData() {
        return "#!/bin/sh\n"
            + "echo \"users %s:CL:%s\n"
            + "allow %s  *\n"
            + "auth strong\n"
            + "proxy -p8880\n"
            + "proxy -p8881 -a\n"
            + "socks -p8882\n"
            + "flush\" | tee /etc/3proxy.cfg\n"
            + "systemctl restart 3proxy";
    }
    /*
     * @Description //创建链接
     * @Date  2024/7/25 10:32
     **/
    private static AsyncClient createClient(String regionId) {
        StaticCredentialProvider provider = StaticCredentialProvider.create(Credential.builder()
            .accessKeyId(getAccessKeyId())
            .accessKeySecret(getAccessKeySecret())
            .build());
        String endpoint = String.format("ecs.%s.aliyuncs.com", regionId);
        return AsyncClient.builder()
            .region(regionId)
            .credentialsProvider(provider)
            .overrideConfiguration(
                ClientOverrideConfiguration.create()
                    .setEndpointOverride(endpoint)
            )
            .build();
    }

    /**
     * 创建并运行实例
     */
    public static RunInstancesResponse runInstances(String owner,String username, String password, CloudPlatformConfig config) {
        AsyncClient client = createClient(config.getRegionId());
        RunInstancesResponse runInstancesResponse = null;
        String userData = String.format(getUserData(), username, password, username);
        try {
            RunInstancesRequest runInstancesRequest = RunInstancesRequest.builder()
                .regionId(config.getRegionId())
                .launchTemplateId(config.getTemplateId())
                .userData(Aes.base64Encode(userData.getBytes()))
                .keyPairName("Proxy_IP")
                .build();
            log.info("调用aliEcs创建并运行实例，入参：owner:{},regionId:{}", owner, config.getRegionId());
            CompletableFuture<RunInstancesResponse> response = client.runInstances(
                runInstancesRequest);
            runInstancesResponse = response.get();
            log.info("调用aliEcs创建并运行实例，响应参数:owner:{},response:{}", owner,
                JSON.toJSON(runInstancesResponse));
        } catch (Exception e) {
            log.error("fail to aliEcs runInstances {}", e.getMessage());
        } finally {
            client.close();
        }
        return runInstancesResponse;
    }

    /**
     * 续费实例
     */
    public static RenewInstanceResponse renewInstance(String regionId) throws Exception {
        RenewInstanceRequest renewInstanceRequest = RenewInstanceRequest.builder()
            //TODO待确定传参
            .build();
        AsyncClient client = createClient(regionId);
        CompletableFuture<RenewInstanceResponse> response = client.renewInstance(
            renewInstanceRequest);
        client.close();
        return response.get();
    }

    /**
     * 查询单个实例
     */
    public static DescribeInstancesResponse getDescribeInstances(String owner, String instanceId,
        String regionId) {
        AsyncClient client = createClient(regionId);
        DescribeInstancesResponse resp = null;
        try {
            String instanceIds = String.format("[\"%s\"]", instanceId);

            DescribeInstancesRequest describeInstancesRequest = DescribeInstancesRequest.builder()
                .regionId(regionId)
                .instanceIds(instanceIds)
                .build();
            log.info("调用aliEcs查询单个实例，入参：owner:{},regionId:{},instanceId:{}",
                owner, regionId, instanceId);
            CompletableFuture<DescribeInstancesResponse> response = client.describeInstances(
                describeInstancesRequest);
            resp = response.get();
            log.info("调用aliEcs查询单个实例，响应参数:owner:{},response:{}", owner,
                JSON.toJSON(resp));

        } catch (Exception e) {
            log.error("fail to aliEcs getDescribeInstances {}", e.getMessage());
        } finally {
            client.close();
        }
        return resp;
    }

    /**
     * 删除ECS
     */
    public static DeleteInstanceResponse deleteInstance(String owner, String instanceId, String regionId) {
        AsyncClient client = createClient(regionId);
        DeleteInstanceResponse resp = null;
        try {
            DeleteInstanceRequest deleteInstanceRequest = DeleteInstanceRequest.builder()
                .instanceId(instanceId)
                .force(true)
                .build();
            log.info("调用aliEcs删除ECS实例，入参：owner:{},instanceId:{},regionId{}",
                owner, instanceId, regionId);
            CompletableFuture<DeleteInstanceResponse> response = client.deleteInstance(
                deleteInstanceRequest);
            resp = response.get();
            log.info("调用aliEcs删除ECS实例，响应参数:owner:{},response:{}", owner,
                JSON.toJSON(resp));
        } catch (Exception e) {
            log.error("fail to aliEcs deleteInstance {}", e.getMessage());
        } finally {
            client.close();
        }
        return resp;
    }

}
