package com.edgec.browserbackend;

import com.aliyun.sdk.service.ecs20140526.models.DeleteInstanceResponse;
import com.edgec.browserbackend.account.domain.UserBalance;
import com.edgec.browserbackend.account.repository.UserBalanceRepository;
import com.edgec.browserbackend.account.service.SmsUtils;
import com.edgec.browserbackend.browser.domain.CloudPlatformConfig;
import com.edgec.browserbackend.browser.repository.CloudPlatformConfigRepository;
import com.edgec.browserbackend.browser.task.BrowserTask;
import com.edgec.browserbackend.common.client.AliEcsClient;
import com.edgec.browserbackend.common.utils.Aes;
import javax.annotation.Resource;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest
class BrowserBackendApplicationTests {

    @Resource
    private UserBalanceRepository userBalanceRepository;

    @Resource
    private BrowserTask browserTask;

    @Resource
    private CloudPlatformConfigRepository cloudPlatformConfigRepository;
    @Test
    void contextLoads() {
        UserBalance userBalance = new UserBalance();
        userBalance.setUsername("13323269174");
        userBalance.setBalanced(100l);
        userBalance.setUsed(0l);
        userBalanceRepository.save(userBalance);
    }

    @Test
    void buyEcsTest() throws Exception {
        CloudPlatformConfig config = cloudPlatformConfigRepository.findByPlatformAndRegionId("ali",
            "cn-hongkong");
        //browserTask.queryIpNewTasks();
       //AliEcsClient.runInstances("111","ceshi11","2222",config);
        //AliEcsClient.getDescribeInstances("测试","i-wz9hf0i13xj6h904k14p","cn-shenzhen");
        DeleteInstanceResponse response = AliEcsClient.deleteInstance("测试", "i-j6ciop90gd68yg5n0sqo","cn-hongkong");
    }

    @Test
    void test3() throws Exception {
        SmsUtils.sendSmsOTP("18711016574");
    }

}
