package com.edgec.browserbackend.account.controller;

import com.edgec.browserbackend.account.exception.AccountErrorCode;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.apache.commons.lang3.StringUtils;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;

public class LimitedUsers {
    private static List<String> getLimitedUsers() {
        return Arrays.asList("cloudam");
    }

    public static void filterIfLimitedUser(Principal principal) {

        if (principal != null && !StringUtils.isEmpty(principal.getName())) {
            if (getLimitedUsers().contains(principal.getName())) {
                throw new ClientRequestException(AccountErrorCode.UNAUTHORIZED, "Not allowed");
            }
        }
    }

    private final static String ADMINISTRATORS = "15919921106";

    public static void filterIfLimitedAdministrators(Principal principal) {
        if (!ADMINISTRATORS.equals(principal.getName())) {
            throw new ClientRequestException(AccountErrorCode.UNAUTHORIZED, "Not allowed");
        }
    }
}
