package com.edgec.browserbackend.browser.dto;

import com.edgec.browserbackend.browser.domain.OperationHistory;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@JsonIgnoreProperties(ignoreUnknown = true)
public class OperationHistoryDto {
    private String account;
    private String nickname;
    private String loginIp;
    private String loginPlace;
    private String operation;
    private String operationTime;
    private String shopBindIp;
    private String shopBindName;

    public OperationHistoryDto(){

    }

    public OperationHistoryDto(OperationHistory operationHistory) {
        if (operationHistory.getUsername() != null)
            this.account = operationHistory.getUsername();
        if (operationHistory.getNickname() != null)
            this.nickname = operationHistory.getNickname();
        if (operationHistory.getLoginIp() != null)
            this.loginIp = operationHistory.getLoginIp();
        if (operationHistory.getLoginPlace() != null)
            this.loginPlace = operationHistory.getLoginPlace();
        if (operationHistory.getOperation() != null)
            this.operation = operationHistory.getOperation();
        if (operationHistory.getOperationTime() != 0)
            this.operationTime = Instant.ofEpochMilli(operationHistory.getOperationTime()).atZone(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        if (operationHistory.getShopBindIp() != null)
            this.shopBindIp = operationHistory.getShopBindIp();
        if (operationHistory.getShopBindName() != null)
            this.shopBindName = operationHistory.getShopBindName();
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getLoginIp() {
        return loginIp;
    }

    public void setLoginIp(String loginIp) {
        this.loginIp = loginIp;
    }

    public String getLoginPlace() {
        return loginPlace;
    }

    public void setLoginPlace(String loginPlace) {
        this.loginPlace = loginPlace;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getOperation() {
        return operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getOperationTime() {
        return operationTime;
    }

    public void setOperationTime(String operationTime) {
        this.operationTime = operationTime;
    }

    public String getShopBindIp() {
        return shopBindIp;
    }

    public void setShopBindIp(String shopBindIp) {
        this.shopBindIp = shopBindIp;
    }

    public String getShopBindName() {
        return shopBindName;
    }

    public void setShopBindName(String shopBindName) {
        this.shopBindName = shopBindName;
    }
}
