package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.Shop;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;

import java.util.List;

public interface ShopRepository extends MongoRepository<Shop, String>, ShopRepositoryCustom {
    Page<Shop> findByShopIdInAndShopAccountLikeOrderByCreateTimeDesc(List<String> shopIds, String shopAccount, Pageable pageable);

    Page<Shop> findByShopIdInAndShopNameLikeOrderByCreateTimeDesc(List<String> shopIds, String shopName, Pageable pageable);

    Page<Shop> findByShopIdInOrderByCreateTimeDesc(List<String> shopIds, Pageable pageable);

    List<Shop> findByShopIdIn(List<String> shopIds);

    List<Shop> findByOwnerIn(List<String> owners);
}
