package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.dto.UserVpsDto;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.result.UpdateResult;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.Pair;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import static org.springframework.data.mongodb.core.query.Criteria.where;

/**
 * @author xuxin
 * @date 2020/8/24 14:08
 * @description
 */
public class UserVpsRepositoryCustomImpl implements UserVpsRepositoryCustom {
    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public boolean deleteVpsIdOfUserVpsList(String id, String vpsId) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("_id").is(id));
        Update update = new Update();
        update.pull("vpsIdList", vpsId);
        UpdateResult result = mongoTemplate.updateFirst(basicQuery, update, UserVpsDto.class);
        return result.getModifiedCount() >= 1;
    }

    @Override
    public List<String> updateAll(List<String> userIds, List<String> vpsIds) {
       /* Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("_id").in(userIds));
        Update update = new Update();
        update.addToSet("vpsIdList").each(vpsIds);
        UpdateResult result = mongoTemplate.updateMulti(basicQuery, update, UserVpsDto.class);*/

        List<Pair<Query, Update>> updateList = new ArrayList<>(userIds.size());
        userIds.forEach(userId -> {
            Document doc = new Document();
            BasicQuery basicQuery = new BasicQuery(doc);
            basicQuery.addCriteria(where("_id").is(userId));
            Update update = new Update();
            update.addToSet("vpsIdList").each(vpsIds);
            Pair<Query, Update> updatePair = Pair.of(basicQuery, update);
            updateList.add(updatePair);
        });

        BulkOperations operations = mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, UserVpsDto.class);
        BulkWriteResult result = operations.upsert(updateList).execute();

        List<String> collect = result.getUpserts().stream().map(x -> x.getId().asString().getValue()).collect(Collectors.toList());
        userIds.removeAll(collect);
        return userIds;
    }
}
