package com.edgec.browserbackend.browser.service.Impl;

import com.edgec.browserbackend.account.domain.Account;
import com.edgec.browserbackend.account.domain.UserPrePaidBilling;
import com.edgec.browserbackend.account.repository.AccountRepository;
import com.edgec.browserbackend.account.repository.UserPrePaidBillingRepository;
import com.edgec.browserbackend.browser.domain.IpResource;
import com.edgec.browserbackend.browser.domain.UserCode;
import com.edgec.browserbackend.browser.dto.TempAccountDto;
import com.edgec.browserbackend.browser.dto.TempReportDto;
import com.edgec.browserbackend.browser.repository.IpResourceRepository;
import com.edgec.browserbackend.browser.repository.UserCodeRepository;
import com.edgec.browserbackend.browser.service.TempService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 *
 */
@Slf4j
@Service
public class TempServiceImpl implements TempService {
    @Autowired
    private UserCodeRepository userCodeRepository;

    @Autowired
    private IpResourceRepository ipResourceRepository;

    @Autowired
    private AccountRepository accountRepository;

    @Autowired
    private UserPrePaidBillingRepository userPrePaidBillingRepository;

    @Override
    public void save(UserCode userCode) {
        userCodeRepository.save(userCode);
    }

    @Override
    public void saveIpResource(String addr, String flag) {
        IpResource ipResource = ipResourceRepository.findByAddr(addr);

        if ("true".equals(flag)) {
            ipResource.setSpecialLine(true);
        }

        if ("false".equals(flag)) {
            ipResource.setSpecialLine(false);
        }

        ipResourceRepository.save(ipResource);
        log.info("ip地址为：" + addr + "专线状态更改为：" + flag);
    }

    @Override
    public String getPassword(String ip) {
        IpResource ipResource = ipResourceRepository.findFirstByAddrOrderByPurchasedTimeDesc(ip);
        StringBuilder proxy = new StringBuilder();
        proxy.append(ipResource.getUsername())
                .append(",")
                .append(ipResource.getPassword());
        if (ipResource.getProxyPassword() != null) {
            proxy.append(",")
                    .append(ipResource.getProxyUsername())
                    .append(",")
                    .append(ipResource.getProxyPassword());
        }
        return proxy.toString();
    }

    @Override
    public TempReportDto getReport() {
        TempReportDto tempReportDto = new TempReportDto();
        List<Account> accounts = accountRepository.findAll();

        List<TempAccountDto> list = accounts.stream().filter(x -> StringUtils.isEmpty(x.getParent())).map(TempAccountDto::new).collect(Collectors.toList());

        for (TempAccountDto tempAccountDto : list) {
            List<UserPrePaidBilling> userPrePaidBillings = userPrePaidBillingRepository.findByUsernameLikeAndPayMethodIn(tempAccountDto.getName(), Arrays.asList(1, 2, 3));
            if (userPrePaidBillings != null && userPrePaidBillings.size() > 0) {
                tempAccountDto.setConsume(userPrePaidBillings.stream().mapToDouble(UserPrePaidBilling::getTotal).sum());
            } else {
                tempAccountDto.setConsume(0.0);
            }
        }

        tempReportDto.setTotalUsers(list.size());
        tempReportDto.setTotalConsume(list.stream().mapToDouble(TempAccountDto::getConsume).sum());
        tempReportDto.setList(list);
        tempReportDto.setNoPromotionCodeUsersNum((int) (list.stream().filter(x -> StringUtils.isEmpty(x.getPromotionCode())).count()));
        tempReportDto.setNoPromotionCodeUsersTotalConsume(list.stream().filter(x -> StringUtils.isEmpty(x.getPromotionCode())).mapToDouble(TempAccountDto::getConsume).sum());
        tempReportDto.setPromotionCode123456UsersNum((int) (list.stream().filter(x -> "123456".equals(x.getPromotionCode())).count()));
        tempReportDto.setPromotionCode123456UsersTotalConsume(list.stream().filter(x -> "123456".equals(x.getPromotionCode())).mapToDouble(TempAccountDto::getConsume).sum());
        return tempReportDto;
    }
}
