package com.edgec.browserbackend.browser.dto;

import java.util.StringTokenizer;

public class Interval implements Comparable {

    private int start;
    private int end;

    public Interval() {

    }


    public Interval(String ports) {
        StringTokenizer stringTokenizer = new StringTokenizer(ports, "-");
        String start = stringTokenizer.nextToken();
        this.start = Integer.parseInt(start.trim());

        if (stringTokenizer.hasMoreTokens()) {
            String end = stringTokenizer.nextToken();
            this.end = Integer.parseInt(end.trim());
        } else {
            this.end = this.start;
        }
    }


    public Interval(int start, int end) {
        this.start = start;
        this.end = end;
    }


    /**
     * @return interval是否为当前区间的子集
     */
    public boolean contains(Interval interval) {
        if (this.getStart() <= interval.getStart() && this.getEnd() >= interval.getEnd()) {
            return true;
        }
        return false;
    }


    public int getStart() {
        return start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return end;
    }

    public void setEnd(int end) {
        this.end = end;
    }


    @Override
    public String toString() {
        if (start == end) {
            return start + "";
        }
        return start + "-" + end;
    }

    public static void main(String[] args) {
        String key = "100";
        String key2 = "100-300";
        String key3 = "100  -  300";
        Interval interval = new Interval(key);
        Interval interval1 = new Interval(key2);
        Interval interval2 = new Interval(key3);

        System.out.println(interval);
        System.out.println(interval1);
        System.out.println(interval2);
    }


    @Override
    public int compareTo(Object o) {
        if (!(o instanceof Interval)) {
            return 0;
        }
        Interval interval = (Interval) o;
        return this.start - interval.start;
    }
}