package main

import (
	"encoding/json"
	"os"
	"github.com/cesanta/docker_auth/auth_server/authz"
	"fmt"
	utils "../utils"
)


func main() {
	text := utils.ReadStdIn()
	// Create the authReqInfo object from the input
	var authReqInfo authz.AuthRequestInfo
	err := json.Unmarshal([]byte(text), &authReqInfo)
	if err != nil {
		os.Exit(utils.ErrorExitCode)
	}

	// Only allowed to "Pull". If "Push" access needed, define the rules via static ACL
	fmt.Println("The user " + authReqInfo.Account + " requesting \"push\" access for the Repo: " + authReqInfo.Name)
	isAuthorized := utils.HttpAuth(authReqInfo)

	if isAuthorized {
		os.Exit(utils.SuccessExitCode)
	} else {
		os.Exit(utils.ErrorExitCode)
	}
}
