import styles from "./index.module.css";
import {
	ITask,
	IParameter,
} from "../../../Project/ProjectSubmitWork/interface";
import noTemplate from "@/assets/project/noTemplate.svg";
import { useEffect, useMemo, useState } from "react";
import MyInput from "@/components/mui/MyInput";
import Tooltip from "@mui/material/Tooltip";
import MyCheckBox from "@/components/mui/MyCheckBox";
// import MySelect, { optionsTransform } from "../components/MySelect";
import MySelect, {
	optionsTransform,
} from "../../../Project/ProjectSubmitWork/components/MySelect";
import MyRadio from "@/components/mui/MyRadio";
import questionMark from "@/assets/project/questionMark.svg";
import fileSelectIcon from "@/assets/project/fileSelect.svg";
import classNames from "classnames";

type IParameterSettingProps = {
	templateConfigInfo: ITask[];
	taskId: string;
};

const templateConfigInfo = [
	{
		id: "id",
		title: "title",
		description:
			"阿斯蒂芬吉林集安拉开圣诞节疯狂拉升阶段阿斯蒂芬吉林集安拉开圣诞节疯狂拉升阶段阿斯蒂芬吉林集安拉开圣诞节疯狂拉升阶段阿斯蒂芬吉林集安拉开圣诞节疯狂拉升阶段阿斯蒂芬吉林集安拉开圣诞节疯狂拉升阶段阿斯蒂芬吉林集安拉开圣诞节疯狂拉升阶段",
		version: "version",
		position: {
			x: 10,
			y: 100,
		},
		tags: ["string[]"],
		type: "BATCH",
		parentNode: "string",
		parameters: [
			{
				hidden: true,
				id: "",
				name: "smi_in",
				required: true,
				defaultValue: null,
				domType: "select",
				classType: "STRING",
				classTypeName: "String",
				value: "",
				description: "",
				language: "",
				languageVersion: "",
				tags: [],
				source: "string",
				productId: "",
				tasks: [],
				validators: [
					{
						message: "请选择smi文件作为输入",
						regex: "^.[s][m][i]$",
					},
				],
				choices: [],
				parameterGroup: "in",
			},
			{
				hidden: true,
				id: "",
				name: "smi_in",
				required: true,
				defaultValue: null,
				domType: "select",
				classType: "STRING",
				classTypeName: "String",
				value: "",
				description: "",
				language: "",
				languageVersion: "",
				tags: [],
				source: "string",
				productId: "",
				tasks: [],
				validators: [
					{
						message: "请选择smi文件作为输入",
						regex: "^.[s][m][i]$",
					},
				],
				choices: [],
				parameterGroup: "out",
			},
		],
		edges: [],
		isCheck: false,
		executionStatus: "Pending",
	},
];
const taskId = "id";
const ParameterSetting = (props: IParameterSettingProps) => {
	// const { templateConfigInfo, taskId } = props;

	const [descHeight, setDescHeight] = useState(0);
	const [isShowAllDese, setIsShowAllDese] = useState(false);

	const [fileSelectOpen, setFileSelectOpen] = useState(false); // 选择输出路径的弹窗显示控制

	const [fileSelectObject, setFileSelectObject] = useState({
		taskId: "",
		parameterName: "",
	});

	const div = document.getElementById("descHeight");
	useEffect(() => {
		if (div) {
			setDescHeight(div.offsetHeight);
		}
	}, [div]);

	const taskInfo: ITask | null = useMemo(() => {
		if (!taskId) {
			return null;
		} else {
			const randerTaskArr = templateConfigInfo.filter(
				(task) => task.id === taskId
			);
			if (randerTaskArr.length > 0) {
				return randerTaskArr[0] as ITask;
			} else {
				return null;
			}
		}
	}, [templateConfigInfo, taskId]);

	// 输入参数
	const inParameters: Array<IParameter> = useMemo(() => {
		if (!taskInfo) {
			return [];
		} else {
			return taskInfo.parameters.filter(
				(parameter) => parameter.parameterGroup === "in"
			);
		}
	}, [taskInfo]);
	console.log(inParameters);

	// 输出参数
	const outParameters: Array<IParameter> = useMemo(() => {
		if (!taskInfo) {
			return [];
		} else {
			return taskInfo.parameters.filter(
				(parameter) => parameter.parameterGroup === "out"
			);
		}
	}, [taskInfo]);

	// // 基础参数
	// const basisParameters: Array<IParameter> = useMemo(() => {
	// 	if (!taskInfo) {
	// 		return [];
	// 	} else {
	// 		return taskInfo.parameters.filter(
	// 			(parameter) => parameter.parameterGroup === "basis"
	// 		);
	// 	}
	// }, [taskInfo]);

	// // 高级选项
	// const seniorParameters: Array<IParameter> = useMemo(() => {
	// 	if (!taskInfo) {
	// 		return [];
	// 	} else {
	// 		return taskInfo.parameters.filter(
	// 			(parameter) => parameter.parameterGroup === "senior"
	// 		);
	// 	}
	// }, [taskInfo]);

	// // 硬件配置
	// const hardwareParameters: Array<IParameter> = useMemo(() => {
	// 	if (!taskInfo) {
	// 		return [];
	// 	} else {
	// 		return taskInfo.parameters.filter(
	// 			(parameter) => parameter.parameterGroup === "hardware"
	// 		);
	// 	}
	// }, [taskInfo]);

	const handleOpenFileSelect = (
		taskId: string = "",
		parameterName: string = ""
	) => {
		setFileSelectObject({
			taskId,
			parameterName,
		});
		setFileSelectOpen(true);
	};

	const handleParameterChange = (
		e: any,
		taskId: string,
		parameterName: string
	) => {
		console.log(e.target.value, taskId, parameterName);
		// setParameter(e.target.value, taskId, parameterName);
	};

	const renderInput = (parameter: IParameter) => {
		return (
			<div>
				{parameter.domType.toLowerCase() === "file" && (
					<MyInput
						value={parameter.value || ""}
						InputProps={{
							endAdornment: (
								<img
									onClick={() => handleOpenFileSelect(taskId, parameter.name)}
									src={fileSelectIcon}
									alt=""
									className={styles.fileSelectImg}
								/>
							),
						}}
						placeholder="请选择"
						error={parameter.error || false}
						helperText={parameter.helperText}
					></MyInput>
				)}
				{parameter.domType.toLowerCase() === "path" && (
					<MyInput
						value={parameter.value || ""}
						InputProps={{
							endAdornment: (
								<img
									onClick={() => handleOpenFileSelect(taskId, parameter.name)}
									src={fileSelectIcon}
									alt=""
									className={styles.fileSelectImg}
								/>
							),
						}}
						placeholder="请选择"
						error={parameter.error || false}
						helperText={parameter.helperText}
					></MyInput>
				)}
				{parameter.domType.toLowerCase() === "dataset" && (
					<MyInput
						value={parameter.value || ""}
						InputProps={{
							endAdornment: (
								<img
									onClick={() => handleOpenFileSelect(taskId, parameter.name)}
									src={fileSelectIcon}
									alt=""
									className={styles.fileSelectImg}
								/>
							),
						}}
						placeholder="请选择"
						error={parameter.error || false}
						helperText={parameter.helperText}
					></MyInput>
				)}
				{parameter.domType.toLowerCase() === "input" && (
					<MyInput
						value={parameter.value || ""}
						onChange={(e: any) =>
							handleParameterChange(e, taskId, parameter.name || "")
						}
						placeholder="请输入"
						error={parameter.error || false}
						helperText={parameter.helperText}
					></MyInput>
				)}
				{parameter.domType.toLowerCase() === "select" && (
					<MySelect
						value={parameter.value}
						onChange={(e: any) =>
							handleParameterChange(e, taskId, parameter.name || "")
						}
						error={parameter.error || false}
						helpertext={parameter.helperText}
						options={optionsTransform(parameter?.choices || [], "label")}
					></MySelect>
				)}
				{parameter.domType.toLowerCase() === "multipleselect" && (
					<MySelect
						value={parameter.value}
						onChange={(e: any) =>
							handleParameterChange(e, taskId, parameter.name || "")
						}
						multiple={true}
						error={parameter.error || false}
						helpertext={parameter.helperText}
						options={optionsTransform(parameter.choices, "label")}
					></MySelect>
				)}
				{parameter.domType.toLowerCase() === "radio" && (
					<MyRadio
						value={parameter.value}
						onChange={(e: any) =>
							handleParameterChange(e, taskId, parameter.name || "")
						}
						options={optionsTransform(parameter.choices, "label")}
						error={parameter.error || false}
						helperText={parameter.helperText}
					></MyRadio>
				)}
				{parameter.domType.toLowerCase() === "checkbox" && (
					<MyCheckBox
						value={parameter.value}
						onChange={(e: any) =>
							handleParameterChange(
								{
									target: {
										value: e,
									},
								},
								taskId,
								parameter.name || ""
							)
						}
						options={optionsTransform(parameter.choices, "label")}
						error={parameter.error || false}
						helperText={parameter.helperText}
					></MyCheckBox>
				)}
				{parameter.description && (
					<Tooltip title={parameter.description} placement="top">
						<img className={styles.parameterDesc} src={questionMark} alt="" />
					</Tooltip>
				)}
			</div>
		);
	};

	return (
		<div className={styles.parameterSetting}>
			{taskInfo && (
				<div className={styles.taskInfo}>
					<div className={styles.taskTitle}>{taskInfo.title || "-"}</div>
					<div className={styles.taskVersion}>
						版本：{taskInfo.version || "-"}
					</div>
					<div className={styles.taskDescriptionHeight} id="descHeight">
						{taskInfo.description || "-"}
					</div>
					<div
						className={classNames({
							[styles.taskDescriptionAll]: isShowAllDese,
							[styles.taskDescription]: !isShowAllDese,
						})}
					>
						{taskInfo.description || "-"}
						{descHeight > 60 && (
							<span
								className={styles.descButton}
								onClick={() => setIsShowAllDese(!isShowAllDese)}
							>
								{isShowAllDese ? "收起" : "展开"}
							</span>
						)}
					</div>
				</div>
			)}
			{inParameters.length > 0 && (
				<div className={styles.inOutBox}>
					<div className={styles.paramsTitle}>
						输入
						<Tooltip
							title="当某个输入项为启用状态时，代表该输入将由模板使用者在使用的时候填写赋值；当为关闭状态时，代表该输入不需要使用者来填写赋值，而是将其它流程的结果传入。"
							placement="top"
						>
							<img
								className={styles.paramsTitleDesc}
								src={questionMark}
								alt=""
							/>
						</Tooltip>
					</div>
					<div className={styles.paramsList}>
						{inParameters.map((parameter, index) => {
							return (
								<div className={styles.parameterBox} key={index}>
									<div className={styles.parameterTop}>
										<div className={styles.parameterleft}>
											<div
												className={classNames({
													[styles.parameterName]: true,
													[styles.required]: parameter.required,
												})}
											>
												{parameter.name}
											</div>
											<div className={styles.parameterdataType}>
												{parameter.classTypeName}
											</div>
										</div>
										<div className={styles.parameterRight}>
											{parameter.hidden}
										</div>
									</div>
									{renderInput(parameter)}
								</div>
							);
						})}
					</div>
				</div>
			)}
			{outParameters.length > 0 && (
				<div className={styles.inOutBox}>
					<div className={styles.paramsTitle}>输出</div>
					<div className={styles.paramsList}>
						{inParameters.map((parameter, index) => {
							return (
								<div className={styles.parameterBox} key={index}>
									<div className={styles.parameterTop}>
										<div className={styles.parameterleft}>
											<div
												className={classNames({
													[styles.parameterName]: true,
													[styles.required]: parameter.required,
												})}
											>
												{parameter.name}
											</div>
											<div className={styles.parameterdataType}>
												{parameter.classTypeName}
											</div>
										</div>
										<div className={styles.parameterRight}>
											{parameter.hidden}
										</div>
									</div>
									{renderInput(parameter)}
								</div>
							);
						})}
					</div>
				</div>
			)}
			{!taskInfo && (
				<div className={styles.noData}>
					<img src={noTemplate} alt="" className={styles.noDataImg} />
					<span className={styles.noDataText}>选中任意算子进行参数设置</span>
				</div>
			)}
		</div>
	);
};

export default ParameterSetting;
