import React, {
  useState,
  useImperativeHandle,
  useCallback,
  useMemo,
  useEffect,
} from "react";

import style from "./index.module.css";
import MyDialog from "@/components/mui/MyDialog";
import folderIcon from "@/assets/project/folderIcon.svg";
import bigFolderIcon from "@/assets/project/bigFolderIcon.svg";
import { useMessage } from "@/components/MySnackbar";
import MyTreeView from "@/components/mui/MyTreeView";
import CloudEController from "@/api/fileserver/CloudEController";
import { getDataFileMove, getDataFileMovePackage } from "@/api/project_api";
import useMyRequest from "@/hooks/useMyRequest";
import classNames from "classnames";
import _ from "lodash";

const MoveFile = (props: any) => {
  const {
    path,
    projectId,
    fileToken,
    currentOperateFile,
    selectIds,
    refresh,
    showList,
  } = props;
  const Message = useMessage();
  const [newPath, setNewPath] = useState("/");
  const [rootActive, setRootActive] = useState(true);
  const [moveFileSubmitloading, setMoveFileSubmitloading] = useState(false);
  const [treeData, setTreeData] = useState<any>([]);
  const [renderTreeData, setRenderTreeData] = useState<any>([]);
  let moveFileDialogRef: any = React.createRef();
  // 要移动的文件夹  之后用来隐藏文件夹树中同路径的文件夹
  const [moveFolderPathArr, setMoveFolderPathArr] = useState<Array<string>>([]);

  const getTree = useCallback(() => {
    if (fileToken && projectId) {
      return CloudEController.JobOutFileDirtree(
        "/",
        fileToken,
        projectId,
        false
      )?.then((res) => {
        if (Array.isArray(res.data)) {
          let arr = res.data;
          setTreeData(arr);
        } else {
          setTreeData([]);
        }
      });
    }
  }, [fileToken, projectId]);

  const getDisabledRepeatFolder = useCallback(
    (folderTree: any, samePathFolederArr: Array<string>) => {
      const arr = _.cloneDeep(folderTree);
      const disabledRepeatFolder = (tree: any, repeatPath: Array<string>) => {
        tree.forEach((item: any, index: number) => {
          if (repeatPath.indexOf(`${item.dir.substr(1)}${item.name}`) !== -1) {
            item.disabled = true;
          } else {
            item.disabled = false;
            if (item.subdirs.length > 0) {
              disabledRepeatFolder(item.subdirs, repeatPath);
            }
          }
        });
      };
      disabledRepeatFolder(arr, samePathFolederArr);
      return arr;
    },
    []
  );

  useEffect(() => {
    const tree = getDisabledRepeatFolder(treeData, moveFolderPathArr);
    setRenderTreeData(tree);
  }, [moveFolderPathArr, getDisabledRepeatFolder, treeData]);

  useEffect(() => {
    let moveFolderArr: any = [];
    let pathArr = [];
    if (currentOperateFile) {
      if (currentOperateFile.type === "directory") {
        moveFolderArr = [currentOperateFile];
      } else {
        moveFolderArr = [];
      }
    } else {
      moveFolderArr = showList.filter((item: any) => {
        return selectIds.indexOf(item.name) !== -1 && item.type === "directory";
      });
    }
    pathArr = moveFolderArr.map((item: any) => {
      return path === "/" ? `/${item.name}` : `${path}/${item.name}`;
    });
    setMoveFolderPathArr(pathArr);
  }, [selectIds, showList, currentOperateFile, path]);

  const showDialog = () => {
    moveFileDialogRef.current.handleClickOpen();
    getTree();
  };

  useImperativeHandle(props.onRef, () => {
    return {
      showDialog: showDialog,
    };
  });

  const { run: getDataFileMoveRun } = useMyRequest(getDataFileMove, {
    onSuccess: (res: any) => {
      successMove();
    },
  });

  const { run: getDataFileMovePackageRun } = useMyRequest(
    getDataFileMovePackage,
    {
      onSuccess: (res: any) => {
        successMove();
      },
    }
  );

  // 提供给fileserver相关接口的newpath 直接用newPath就可以了
  // const newPathProvidedToFileServer = useMemo(() => {
  //   return newPath
  // }, [newPath])

  // 提供给数据集相关接口的newpath
  const newPathProvidedToDataSet = useMemo(() => {
    return newPath === "/" ? "/" : `${newPath}/`;
  }, [newPath]);

  // 提供给fileserver相关接口的oldpath
  const oldPathProvidedToFileServer = useMemo(() => {
    return `${path}${path === "/" ? "" : "/"}`;
  }, [path]);

  // 提供给数据集相关接口的oldpath
  const oldPathProvidedToDataSet = useMemo(() => {
    return path === "/" ? "/" : `${path}/`;
  }, [path]);

  // 移动成功后的操作
  const successMove = () => {
    Message.success("移动成功！");
    setMoveFileSubmitloading(false);
    moveFileDialogRef?.current?.handleClose();
    refresh();
  };

  // 移动失败后的操作
  const erroeMove = (error: any) => {
    if (error?.response?.status === 405) {
      Message.error("因目标路径存在同名文件，数据移动失败。");
    } else {
      Message.error("文件服务发生错误，数据移动失败。");
    }
    setMoveFileSubmitloading(false);
  };

  // 移动
  const handleMoveFileSubmit = () => {
    if (!newPath) {
      Message.error("请选择移动到哪个目录");
    } else if (newPath === path) {
      Message.error("指定的目标路径为数据原路径，无需移动。");
    } else {
      setMoveFileSubmitloading(true);
      if (!currentOperateFile) {
        // 批量移动
        // 要移动的数据集
        const datSetMoveList = showList.filter((item: any) => {
          return selectIds.indexOf(item.name) !== -1 && item.type === "dataSet";
        });
        // 要移动的文件夹
        const folderMoveList = showList.filter((item: any) => {
          return (
            selectIds.indexOf(item.name) !== -1 && item.type === "directory"
          );
        });
        // 要移动的文件
        const fileMoveList = showList.filter((item: any) => {
          return (
            selectIds.indexOf(item.name) !== -1 &&
            item.type !== "dataSet" &&
            item.type !== "directory"
          );
        });
        if (datSetMoveList.length > 0) {
          dataSetsMove(datSetMoveList);
        }
        if (folderMoveList.length > 0) {
          foldersMove(folderMoveList);
        }
        if (fileMoveList.length > 0) {
          filesMove(fileMoveList)?.then((res) => {
            successMove();
          });
        }
      } else {
        if (currentOperateFile.type === "dataSet") {
          dataSetMove();
        } else if (currentOperateFile.type === "directory") {
          folerMove();
        } else {
          fileMove()?.then((res) => {
            successMove();
          });
        }
      }
    }
  };

  // 单文件移动
  const fileMove = () => {
    const oldPathToFileServer = `${oldPathProvidedToFileServer}${currentOperateFile.name}`;
    return CloudEController.JobFileMove(
      newPath,
      oldPathToFileServer,
      "",
      fileToken,
      projectId
    );
  };

  // 多文件移动
  const filesMove = (fileMoveList: Array<any>) => {
    const oldPaths = fileMoveList.map((item: any) => {
      return `${oldPathProvidedToFileServer}${item.name}`;
    });
    return CloudEController.JobFileBatchMove(
      newPath,
      oldPaths,
      "",
      fileToken,
      projectId
    );
  };

  // 单文件夹移动
  const folerMove = () => {
    fileMove()
      ?.then((res) => {
        const names = currentOperateFile.name;
        dataSetInFolerMove(names);
      })
      .catch((error) => {
        console.log(error);
        erroeMove(error);
      });
  };

  // 移动文件夹中的数据集
  const dataSetInFolerMove = (names: string) => {
    getDataFileMovePackageRun({
      projectId: projectId as string,
      names,
      spath: oldPathProvidedToDataSet,
      dpath: newPathProvidedToDataSet,
    });
  };

  // 多文件夹移动
  const foldersMove = (folderMoveList: Array<any>) => {
    filesMove(folderMoveList)
      ?.then((res) => {
        const names = folderMoveList.map((item: any) => item.name).join(",");
        dataSetInFolerMove(names);
      })
      .catch((error) => {
        console.log(error);
        erroeMove(error);
      });
  };

  // 单数据集移动
  const dataSetMove = () => {
    getDataFileMoveRun({
      projectId: projectId as string,
      names: currentOperateFile.name,
      spath: oldPathProvidedToDataSet,
      dpath: newPathProvidedToDataSet,
    });
  };

  // 多数据集移动
  const dataSetsMove = (datSetMoveList: Array<any>) => {
    getDataFileMoveRun({
      projectId: projectId as string,
      names: datSetMoveList.map((item: any) => item.name).join(","),
      spath: oldPathProvidedToFileServer,
      dpath: newPath === "/" ? "/" : `${newPath}/`,
    });
  };

  const renderLabel = (labelNmae: string) => {
    return (
      <span className={style.treeLabel}>
        <img className={style.labelFolderIcon} src={folderIcon} alt="" />
        <span className={style.treeLabelText}>{labelNmae}</span>
      </span>
    );
  };

  const onNodeSelect = (a: any, b: any) => {
    setNewPath(b);
    setRootActive(false);
  };

  // 给路径去掉第一个'/'然后结尾加上文件名 方便后面直接使用
  const idFunc = (item: any) => {
    return `${item.dir.substr(1)}${item.name}`;
  };

  const handleRoot = () => {
    setNewPath("/");
    setRootActive(true);
  };

  return (
    <MyDialog
      handleSubmit={handleMoveFileSubmit}
      onRef={moveFileDialogRef}
      title="移动至"
      submitloading={moveFileSubmitloading}
    >
      <div
        className={classNames({
          [style.rootTitle]: true,
          [style.rootTitleActive]: rootActive,
        })}
        onClick={handleRoot}
      >
        <img className={style.bigFolderIcon} src={bigFolderIcon} alt="" />
        ProjectData
      </div>
      <MyTreeView
        // treeData={treeData}
        treeData={renderTreeData}
        renderLabel={renderLabel}
        onNodeSelect={onNodeSelect}
        idFunc={idFunc}
        treeViewSx={{
          width: 400,
          overflow: "hidden",
        }}
      ></MyTreeView>
    </MyDialog>
  );
};

export default MoveFile;
