/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-21 20:03:56
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-24 16:04:32
 * @FilePath: /bkunyun/src/views/Project/ProjectSubmitWork/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { useEffect, useState } from "react";
import ButtonComponent from "@/components/mui/Button";
import ArrowBackIosNewIcon from "@mui/icons-material/ArrowBackIosNew";
import IconButton from "@mui/material/IconButton";
import useMyRequest from "@/hooks/useMyRequest";
import { fetchWorkFlowJob } from "@/api/project_api";
import { useLocation } from "react-router-dom";
import { IResponse } from "@/api/http";

import styles from "./index.module.css";
import { ITemplateConfig } from "../ProjectSubmitWork/interface";

const ProjectSubmitWork = () => {
  const [workFlowJobInfo, setWorkFlowJobInfo] = useState<ITemplateConfig>();
  const location: any = useLocation();

  /** 获取模版数据 */
  const { run } = useMyRequest(fetchWorkFlowJob, {
    onSuccess: (res: IResponse<ITemplateConfig>) => {
      console.log(res.data, "1111");
      setWorkFlowJobInfo(res.data);
    },
  });

  useEffect(() => {
    run({
      id: "42d69257-b579-4c7d-bc27-8f8ab1fd3ea3",
    });
  }, [run]);

  return (
    <div className={styles.swBox}>
      <div className={styles.swHeader}>
        <div className={styles.swHeaderLeft}>
          <IconButton
            color="primary"
            aria-label="upload picture"
            component="span"
            size="small"
          >
            <ArrowBackIosNewIcon
              sx={{
                color: "rgba(194, 198, 204, 1)",
                width: "12px",
                height: "12px",
              }}
            />
          </IconButton>

          <div className={styles.swTemplateTitle}>{workFlowJobInfo?.title}</div>
        </div>
        <div className={styles.swHeaderRight}>
          <ButtonComponent
            text="终止"
            variant="outlined"
            color="secondary"
          ></ButtonComponent>
        </div>
      </div>
      <div className={styles.swContent}>
        <div className={styles.swFormBox}>
          <div>详情</div>
        </div>
        <div className={styles.swFlowBox}>
          <div>图表</div>
        </div>
      </div>
    </div>
  );
};

export default ProjectSubmitWork;
