import React, { useState, useImperativeHandle } from "react";

import { TextField } from "@mui/material";
import MyDialog from "@/components/mui/MyDialog";
import { checkIsNumberLetterChinese } from "@/utils/util";
import { useMessage } from "@/components/MySnackbar";
import CloudEController from "@/api/fileserver/CloudEController";
import InputAdornment from '@mui/material/InputAdornment';

const AddFolder = (props: any) => {
  const { list, path, projectId, fileToken, refresh } = props;
  const Message = useMessage();
  let addFolderDialogRef: any = React.createRef();
  const [fileName, setFileName] = useState("");
  const [fileNameCheck, setFileNameCheck] = useState({
    error: false,
    help: "",
  });

  const showDialog = () => {
    addFolderDialogRef.current.handleClickOpen();
    initData()
  };

  const initData = () => {
    setFileName('')
    setFileNameCheck({
      error: false,
      help: "",
    })
  }

  useImperativeHandle(props.onRef, () => {
    return {
      showDialog: showDialog,
    };
  });

  const handleAddSubmit = () => {
    if (fileName && !fileNameCheck.error) {
      const newFolderPath =
        path === "/" ? `${path}${fileName}` : `${path}/${fileName}`;
      // 请求接口
      CloudEController.JobFileNewFolder(
        newFolderPath,
        fileToken,
        projectId
      )?.then((res) => {
        Message.success("新建成功");
        addFolderDialogRef.current.handleClose();
        refresh()
      });
    } else {
      Message.info(fileNameCheck.help || "请输入文件夹名称");
    }
  };

  const addFolderSubmitloading = false;
  const handleFileNameChange = (e: any) => {
    const fileName = e.target.value;
    setFileName(fileName);
    if (!fileName) {
      setFileNameCheck({
        error: true,
        help: "文件夹名称不能为空",
      });
    } else if (!checkIsNumberLetterChinese(fileName) || fileName.length > 30) {
      setFileNameCheck({
        error: true,
        help: "格式不正确，必须在30字符以内，仅限大小写字母、数字、中文",
      });
    } else if (isRepeat(fileName)) {
      setFileNameCheck({
        error: true,
        help: "已存在同名文件夹",
      });
    } else {
      setFileNameCheck({
        error: false,
        help: "",
      });
    }
  };

  const isRepeat = (fileName: string) => {
    return list.some((item: any) => {
      return item.name === fileName;
    });
  };

  return (
    <MyDialog
      handleSubmit={handleAddSubmit}
      onRef={addFolderDialogRef}
      title="新建文件夹"
      submitloading={addFolderSubmitloading}
    >
      <TextField
        sx={{
          width: "388px",
          border: "1px solide #E6E8EB",
          marginTop: "12px",
        }}
        required
        error={fileNameCheck.error}
        id="fileName"
        label="名称"
        variant="outlined"
        value={fileName}
        onChange={handleFileNameChange}
        helperText={fileNameCheck.help}
        InputProps={{
          endAdornment: <InputAdornment position="end">{fileName.length}/30</InputAdornment>,
        }}
        size="small"
      />
    </MyDialog>
  );
};

export default AddFolder;
