
import { memo, useCallback, useEffect, useMemo, useState } from "react";
import styles from "../index.module.css";
import { Box, Typography } from "@mui/material";
import Button from "@mui/material/Button";
import Dialog from "@/components/mui/Dialog";

const SimpleDialog = (props: any) => {
    const { openDialog, closeDialog, onConfirm, text, title } = props;

    return (
        < >
            <Dialog
                open={openDialog}
                onClose={closeDialog}
                onConfirm={onConfirm}
                title={title}
            >
                <Box>
                    <Typography sx={{ fontSize: '14px', fontWeight: '400' }}>{text}</Typography>
                </Box>
            </Dialog>
        </>
    );
};

export default memo(SimpleDialog);
