import { operation, route } from "@/router";
import { useStores } from "@/store";
import { useCallback } from "react";

const usePass = () => {
  const { permissionStore } = useStores();

  const isPass = useCallback(
    (key: string, routes?: Array<route | operation>): boolean => {
      if (routes) {
        for (let item of routes) {
          if (item.id === key) {
            return true;
          } else if (
            item.type === "page" &&
            item.children?.length &&
            isPass(key, item.children)
          ) {
            return true;
          }
        }
      } else {
        for (let item of permissionStore.allRoutes) {
          if (item.type !== "navigate" && item.id === key) {
            return true;
          } else if (
            item.type === "page" &&
            item.children?.length &&
            isPass(key, item.children)
          ) {
            return true;
          }
        }
      }
      return false;
    },
    [permissionStore.allRoutes]
  );

  return isPass;
};

export default usePass;
