const Mock = require("mockjs");

const random = Mock.Random;

const roles = [
  "HPCSECURITYADMIN",
  "HPCSYSADMIN",
  "HPCACCOUNTADMIN",
  "HPCORGADMIN",
];

const demo = [
  {
    url: "/accounts/current-mock",
    type: "get",
    response: {
      edition: "STANDARD",
      roles: random.pick(roles),
    },
  },
  {
    url: "/accounts/menu-mock",
    type: "get",
    response: {
      code: 200,
      data: [
        {
          id: "cadd",
          name: "CADD",
          icon: "",
          type: "product",
          routes: [
            {
              id: "PROJECT_OVERIVEW",
              type: "page",
              name: "总览",
              path: "/overview",
              icon: "",
              element: "Demo",
              show: "true",
              children: [
                {
                  id: "PROJECT_OVERIVEW_CREATE",
                  type: "operation",
                  name: "创建项目",
                },
              ],
            },
            {
              id: "PROJECT_SUMMARY",
              type: "page",
              name: "项目概览",
              path: "/summary",
              icon: "",
              element: "Demo",
              show: "true",
              children: [
                {
                  id: "PROJECT_SUMMARY_MEMBER",
                  type: "operation",
                  name: "成员管理",
                },
              ],
            },
          ],
        },
        {
          id: "userCenter",
          name: "个人中心",
          icon: "",
          type: "utility",
          routes: [
            {
              id: "USERINFORMATION",
              type: "page",
              name: "账号信息",
              path: "/userInformation",
              icon: "",
              element: "Demo",
              show: "true",
              children: [
                {
                  id: "USERINFORMATION_BASEINFO",
                  type: "operation",
                  name: "基础信息",
                },
              ],
            },
          ],
        },
      ],
    },
  },
];

export default demo;
