import ConsoleLayout from "@/views/ConsoleLayout";
import Home from "@/views/Home";
import MenuLayout from "@/views/MenuLayout";
import * as React from "react";
import NotFound from "@/views/404";
import Demo from "@/views/demo";

export type route = {
  id?: string;
  type: "page";
  name: string;
  path: string;
  element: React.FC<{ childrenRoutes?: Array<route | operation> }>;
  icon?: string;
  show?: boolean;
  children?: Array<route | operation>;
};

export type navigate = {
  type: "navigate";
  from: string;
  to: string;
};

export type operation = {
  id: string;
  type: "operation";
  name: string;
};

export const elements: {
  [x: string]: ({
    childrenRoutes,
  }: {
    childrenRoutes?: Array<route | operation>;
  }) => JSX.Element;
} = {
  Demo: Demo,
};

export const routes: Array<route | navigate> = [
  {
    type: "navigate",
    from: "/",
    to: "/home",
  },
  {
    type: "navigate",
    from: "/product",
    to: "/home",
  },
  {
    type: "page",
    name: "Console",
    path: "/",
    element: ConsoleLayout,
    children: [
      {
        type: "page",
        name: "Home",
        path: "/home",
        element: Home,
      },
      {
        type: "page",
        name: "Product",
        path: "/product",
        element: MenuLayout,
        children: [],
      },
    ],
  },
  {
    type: "page",
    name: "404",
    path: "*",
    element: NotFound,
  },
];
