import { Box, Button, Menu, MenuItem, IconButton } from "@mui/material";
import React, { useEffect } from "react";
import { Outlet, useLocation, useNavigate } from "react-router-dom";
import style from "./index.module.css";
import globalText from "@/utils/globalText_CN";
import AccountCircleIcon from "@mui/icons-material/AccountCircle";
import useIndex from "./useIndex";
import { useStores } from "@/store/index";
import { observer } from "mobx-react-lite";

const ConsoleLayout = observer(() => {
  const {
    productAnchorEl,
    utilityAnchorEl,
    productOpen,
    utilityOpen,
    handleProductClick,
    handleUtilityClick,
    handleClose,
  } = useIndex();

  const navigate = useNavigate();
  const location = useLocation();
  const { permissionStore, menuStore } = useStores();

  useEffect(() => {
    permissionStore.setSidebarRouters(location.pathname);
  }, [location, permissionStore]);

  return (
    <Box>
      <Box className={style.topApp}>
        <Box>
          <Button onClick={() => navigate("/home")}>
            {globalText.console}
          </Button>
          <Button id="product-button" onClick={handleProductClick}>
            {globalText.product}
          </Button>
          <Menu
            id="product-menu"
            anchorEl={productAnchorEl}
            open={productOpen}
            onClose={handleClose}
            MenuListProps={{
              "aria-labelledby": "product-button",
            }}
          >
            {menuStore.productList.map((item) => {
              return (
                <MenuItem
                  key={item.path}
                  onClick={() => {
                    navigate(item.path);
                    handleClose();
                  }}
                >
                  {item.name}
                </MenuItem>
              );
            })}
          </Menu>
        </Box>
        <Box>
          <IconButton
            id="utility-button"
            color="primary"
            onClick={handleUtilityClick}
          >
            <AccountCircleIcon></AccountCircleIcon>
          </IconButton>
          <Menu
            id="utility-menu"
            anchorEl={utilityAnchorEl}
            open={utilityOpen}
            onClose={handleClose}
            MenuListProps={{
              "aria-labelledby": "utility-button",
            }}
          >
            {menuStore.utilityList.map((item) => {
              return (
                <MenuItem
                  key={item.path}
                  onClick={() => {
                    navigate(item.path);
                    handleClose();
                  }}
                >
                  {item.name}
                </MenuItem>
              );
            })}
          </Menu>
        </Box>
      </Box>
      <Box>
        <Outlet></Outlet>
      </Box>
    </Box>
  );
});

export default ConsoleLayout;
