import styles from "./index.module.css";
import {
	ITask,
	// IParameter,
} from "../../../Project/ProjectSubmitWork/interface";
import noTemplate from "@/assets/project/noTemplate.svg";
import { useEffect, useMemo, useState } from "react";
import classNames from "classnames";

type IParameterSettingProps = {
	templateConfigInfo: ITask[];
	taskId: string;
};

const ParameterSetting = (props: IParameterSettingProps) => {
	const { templateConfigInfo, taskId } = props;

	const [descHeight, setDescHeight] = useState(0);
	const [isShowAllDese, setIsShowAllDese] = useState(false);

	const div = document.getElementById("descHeight");
	useEffect(() => {
		if (div) {
			setDescHeight(div.offsetHeight);
		}
	}, [div]);

	const taskInfo: ITask | null = useMemo(() => {
		if (!taskId) {
			return null;
		} else {
			const randerTaskArr = templateConfigInfo.filter(
				(task) => task.id === taskId
			);
			if (randerTaskArr.length > 0) {
				return randerTaskArr[0];
			} else {
				return null;
			}
		}
	}, [templateConfigInfo, taskId]);

	// 输入参数
	// const inParameters: Array<IParameter> = useMemo(() => {
	// 	if (!taskInfo) {
	// 		return [];
	// 	} else {
	// 		return taskInfo.parameters.filter(
	// 			(parameter) => parameter.parameterGroup === "in"
	// 		);
	// 	}
	// }, [taskInfo]);

	// // 输出参数
	// const outParameters: Array<IParameter> = useMemo(() => {
	// 	if (!taskInfo) {
	// 		return [];
	// 	} else {
	// 		return taskInfo.parameters.filter(
	// 			(parameter) => parameter.parameterGroup === "out"
	// 		);
	// 	}
	// }, [taskInfo]);

	// // 基础参数
	// const basisParameters: Array<IParameter> = useMemo(() => {
	// 	if (!taskInfo) {
	// 		return [];
	// 	} else {
	// 		return taskInfo.parameters.filter(
	// 			(parameter) => parameter.parameterGroup === "basis"
	// 		);
	// 	}
	// }, [taskInfo]);

	// // 高级选项
	// const seniorParameters: Array<IParameter> = useMemo(() => {
	// 	if (!taskInfo) {
	// 		return [];
	// 	} else {
	// 		return taskInfo.parameters.filter(
	// 			(parameter) => parameter.parameterGroup === "senior"
	// 		);
	// 	}
	// }, [taskInfo]);

	// // 硬件配置
	// const hardwareParameters: Array<IParameter> = useMemo(() => {
	// 	if (!taskInfo) {
	// 		return [];
	// 	} else {
	// 		return taskInfo.parameters.filter(
	// 			(parameter) => parameter.parameterGroup === "hardware"
	// 		);
	// 	}
	// }, [taskInfo]);

	return (
		<div className={styles.parameterSetting}>
			{taskInfo && (
				<div className={styles.taskInfo}>
					<div className={styles.taskTitle}>{taskInfo.title || "-"}</div>
					<div className={styles.taskVersion}>
						版本：{taskInfo.version || "-"}
					</div>
					<div className={styles.taskDescriptionHeight} id="descHeight">
						{taskInfo.description || "-"}
					</div>
					<div
						className={classNames({
							[styles.taskDescriptionAll]: isShowAllDese,
							[styles.taskDescription]: !isShowAllDese,
						})}
					>
						{taskInfo.description || "-"}
						{descHeight > 60 && (
							<span
								className={styles.descButton}
								onClick={() => setIsShowAllDese(!isShowAllDese)}
							>
								{isShowAllDese ? "收起" : "展开"}
							</span>
						)}
					</div>
				</div>
			)}
			{!taskInfo && (
				<div className={styles.noData}>
					<img src={noTemplate} alt="" className={styles.noDataImg} />
					<span className={styles.noDataText}>选中任意算子进行参数设置</span>
				</div>
			)}
		</div>
	);
};

export default ParameterSetting;
