//  const API = "https://fileserver.cloudam.cn:8091"
//  const APIOPTION = "https://fileserver.cloudam.cn"
//  const APIPORT = "39.105.230.38"
import { getLoaclStorageOfKey } from "./utils";

const API = function () {
  const raysyncAddr = getLoaclStorageOfKey("raysyncAddr");
  return raysyncAddr.srcAddr ? `https://${raysyncAddr.srcAddr}:8091` : "";
};

// 文件服务器指向
const APIOPTION = function () {
  // todo isPrivatization
  let fileServerEndPoint = localStorage.getItem("fileServerEndPoint");
  if (fileServerEndPoint) {
    return fileServerEndPoint;
  } else {
    // 云超算逻辑
    const raysyncAddr = getLoaclStorageOfKey("raysyncAddr");
    return raysyncAddr.fileServerEndPoint || "";
  }
};

// api端口号
const APIPORT = function () {
  const raysyncAddr = getLoaclStorageOfKey("raysyncAddr");
  return raysyncAddr.srcIp || "";
};

// 当前计算区
let currentRegion = localStorage.getItem("current-region");
let currentRegionJson = currentRegion && JSON.parse(currentRegion);
let user = getLoaclStorageOfKey("userinfo");

// 文件路径
const FILEPATH =
  currentRegionJson &&
  currentRegionJson.location &&
  currentRegionJson.location === "ON_PREMISE" &&
  localStorage.getItem("userinfo")
    ? `/home/${user.name}`
    : "/home/cloudam";
const FILEPATH_SHARE = "/share";

// 工作日志
const APIJOBLOGPOINT = function () {
  const raysyncAddr = getLoaclStorageOfKey("raysyncAddr");
  return raysyncAddr.jobLogServerEndPoint || "";
};

// 区id
const ZONEID = (params: string) => {
  let currentRegion = getLoaclStorageOfKey("current-region");
  return currentRegion[params || "id"] || "";
};

const urlToken = (filetoken: string, projectId: string) => {
  let token = getLoaclStorageOfKey("token_key").access_token;
  return `?username=${projectId}&token=${token}&filetoken=${encodeURIComponent(
    filetoken
  )}&share=false&project=true`;
};

const getUuid = () => {
  const userInfo = getLoaclStorageOfKey("userinfo");
  // 是否共有文件系统
  if (
    localStorage.getItem("isShareFileSystem") &&
    localStorage.getItem("isShareFileSystem") === "true"
  ) {
    return userInfo["shareDirectoryMountPoint"];
  } else {
    return userInfo["homeDirectoryMountPoint"];
  }
};

const USERNAME = () => {
  return getLoaclStorageOfKey("userinfo").name;
};

// 加密传输
const encryptTransfer = () => {
  const userInfo = getLoaclStorageOfKey("userinfo");
  if (userInfo) {
    let encryptTransfer = userInfo.encryptTransfer;
    if (encryptTransfer) {
      return true;
    }
    return false;
  }
  return false;
};

const getType = function () {
  if (
    localStorage.getItem("isShareFileSystem") &&
    localStorage.getItem("isShareFileSystem") === "true"
  ) {
    return "share";
  } else {
    return "data";
  }
};
export {
  API,
  APIPORT,
  FILEPATH,
  FILEPATH_SHARE,
  APIOPTION,
  APIJOBLOGPOINT,
  ZONEID,
  urlToken,
  USERNAME,
  getUuid,
  encryptTransfer,
  getType,
};

// const raysyncAddr = {
//   bandwidth: null
//   capacity: 10485760
//   enableLargeFileTransfer: true
//   fileServerEndPoint: "https://fileserver.cloudam.cn"
//   fileSystemType: "standard"
//   jobLogServerEndPoint: "https://fileserver.cloudam.cn:6677"
//   privateIp: "10.8.2.67"
//   protocolType: "NFS"
//   publicMountDir: "/public"
//   publicMountUrl: "132594ad6e-atf93.cn-beijing.nas.aliyuncs.com"
//   ramUserId: "61261f8a2a2aa4d72f752c3c"
//   smbMountUrl: null
//   srcAddr: "fileserver.cloudam.cn"
//   srcIp: "47.94.198.50"
//   sshServerEndPoint: "https://fileserver.cloudam.cn:8888"
//   storageType: "Capacity"
//   token: null
//   userMountDir: "/public/data/"
//   userMountUrl: "132594ad6e-uop2.cn-beijing.nas.aliyuncs.com"
//   vncServerEndPoint: "https://fileserver.cloudam.cn:9090"
//   zoneId: "cn-beijing-h"
// }
// const currentRegion = {
//   cloudProvider: "ALIYUN"
// description: "本计算区有丰富的CPU资源，并提供部分GPU资源，可以满足大部分计算作业需求。"
// enabled: true
// id: "CE-Z1"
// initialized: true
// location: "CLOUD"
// name: "通用计算区"
// primary: true
// storageConfig: {srcAddr: "fileserver.cloudam.cn", srcIp: "47.94.198.50", privateIp: "10.8.2.67",…}
// bandwidth: null
// capacity: 10485760
// enableLargeFileTransfer: true
// fileServerEndPoint: "https://fileserver.cloudam.cn"
// fileSystemType: "standard"
// jobLogServerEndPoint: "https://fileserver.cloudam.cn:6677"
// privateIp: "10.8.2.67"
// protocolType: "NFS"
// publicMountDir: "/public"
// publicMountUrl: "132594ad6e-atf93.cn-beijing.nas.aliyuncs.com"
// ramUserId: "61261f8a2a2aa4d72f752c3c"
// smbMountUrl: null
// srcAddr: "fileserver.cloudam.cn"
// srcIp: "47.94.198.50"
// sshServerEndPoint: "https://fileserver.cloudam.cn:8888"
// storageType: "Capacity"
// token: null
// userMountDir: "/public/data/"
// userMountUrl: "132594ad6e-uop2.cn-beijing.nas.aliyuncs.com"
// vncServerEndPoint: "https://fileserver.cloudam.cn:9090"
// zoneId: "cn-beijing-h"
// }
