/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-07 18:37:53
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-14 17:21:52
 * @FilePath: /bkunyun/src/utils/util.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */

import { v4 as uuidv4 } from "uuid";

export const isProjectOwner = (name: string) => {
  let localName = "";
  try {
    localName = JSON.parse(localStorage.getItem("userInfo") || "{}")?.name;
  } catch {
    console.error("获取localStorage出错");
  }
  return localName === name;
};

/**
 * 生成32位的随机id
 * @returns 返回32位的uuid
 */
export const uuid = () => {
  const reg = /-/g;
  const pwd = uuidv4().replace(reg, "");
  return pwd;
};

// 获取用户信息
export const getUserInfo = () => {
  let val: any;
  try {
    val = JSON.parse(localStorage.getItem("userInfo") || "{}");
  } catch {
    console.error("获取用户信息 出错");
  }
  return val;
};

// 获取token信息
export const getTokenInfo = () => {
  let val: any;
  try {
    val = JSON.parse(localStorage.getItem("token_key") || "{}");
  } catch {
    console.error("获取token信息 出错");
  }
  return val;
};

const IsNumberLetterChineseReg = new RegExp("^[A-Za-z0-9\u4e00-\u9fa5]+$");

export const checkIsNumberLetterChinese = (string: string) => {
  return IsNumberLetterChineseReg.test(string);
};

export const getMbfromB = (b: number) => {
  return Math.floor(b / 1048576);
};
