import React, { useState, useImperativeHandle, useCallback } from "react";

import style from "./index.module.css";
import MyDialog from "@/components/mui/MyDialog";
import folderIcon from "@/assets/project/folderIcon.svg";
import bigFolderIcon from "@/assets/project/bigFolderIcon.svg";
import { useMessage } from "@/components/MySnackbar";
import MyTreeView from "@/components/mui/MyTreeView";
import CloudEController from "@/api/fileserver/CloudEController";
import { getDataFileMove } from "@/api/project_api";
import useMyRequest from "@/hooks/useMyRequest";
import classNames from "classnames";

const MoveFile = (props: any) => {
  const {
    path,
    projectId,
    fileToken,
    currentOperateFile,
    selectIds,
    refresh,
    activeTab,
    showList,
  } = props;
  const Message = useMessage();
  const { run: getDataFileMoveRun } = useMyRequest(getDataFileMove, {
    onSuccess: (res: any) => {
      Message.success("移动成功！");
      moveFileDialogRef.current.handleClose();
      refresh();
    },
  });
  const [newPath, setNewPath] = useState("/");
  const [rootActive, setRootActive] = useState(true);

  const [treeData, setTreeData] = useState<any>([]);

  const getTree = useCallback(() => {
    if (fileToken && projectId) {
      return CloudEController.JobOutFileDirtree(
        "/",
        fileToken,
        projectId,
        false
      )?.then((res) => {
        if (Array.isArray(res.data)) {
          setTreeData(res.data);
        } else {
          setTreeData([]);
        }
      });
    }
  }, [fileToken, projectId]);

  let moveFileDialogRef: any = React.createRef();

  const showDialog = () => {
    moveFileDialogRef.current.handleClickOpen();
    getTree();
  };

  useImperativeHandle(props.onRef, () => {
    return {
      showDialog: showDialog,
    };
  });

  const handleMoveFileSubmit = () => {
    if (newPath) {
      if (!currentOperateFile) {
        // 批量移动
        if (activeTab === 1) {
          const oldPaths = selectIds.map((name: any) => {
            return `${path}${path === "/" ? "" : "/"}${name}`;
          });
          CloudEController.JobFileBatchMove(
            newPath,
            oldPaths,
            "",
            fileToken,
            projectId
          )?.then((res) => {
            Message.success("移动成功！");
            moveFileDialogRef.current.handleClose();
            refresh();
          });
        } else {
          const datSetMoveList = showList.filter((item: any) => {
            return (
              selectIds.indexOf(item.name) !== -1 && item.type === "dataSet"
            );
          });
          const otherMoveList = showList.filter((item: any) => {
            return (
              selectIds.indexOf(item.name) !== -1 && item.type !== "dataSet"
            );
          });
          if (datSetMoveList.length > 0) {
            const oldPaths = `${path}${path === "/" ? "" : "/"}`;
            getDataFileMoveRun({
              projectId: projectId as string,
              names: datSetMoveList.map((item: any) => item.name).join(","),
              spath: oldPaths,
              dpath: newPath === "/" ? "/" : `${newPath}/`,
            });
          }
          if (otherMoveList.length > 0) {
            const oldPaths = otherMoveList.map((item: any) => {
              return `${path}${path === "/" ? "" : "/"}${item.name}`;
            });
            CloudEController.JobFileBatchMove(
              newPath,
              oldPaths,
              "",
              fileToken,
              projectId
            )?.then((res) => {
              Message.success("移动成功！");
              moveFileDialogRef.current.handleClose();
              refresh();
            });
          }
        }
      } else {
        if (currentOperateFile.type === "dataSet") {
          const oldPaths = `${path}${path === "/" ? "" : "/"}`;
          getDataFileMoveRun({
            projectId: projectId as string,
            names: currentOperateFile.name,
            spath: oldPaths,
            dpath: newPath === "/" ? "/" : `${newPath}/`,
          });
        } else {
          const oldPath = `${path}${path === "/" ? "" : "/"}${
            currentOperateFile.name
          }`;
          if (oldPath === newPath) {
            Message.info("指定的目标路径为数据原路径，无需移动。");
            return;
          }
          CloudEController.JobFileMove(
            newPath,
            oldPath,
            "",
            fileToken,
            projectId
          )?.then((res) => {
            Message.success("移动成功！");
            moveFileDialogRef.current.handleClose();
          });
        }
      }
    } else {
      Message.error("请选择移动到哪个目录");
    }
  };

  const renderLabel = (labelNmae: string) => {
    return (
      <span className={style.treeLabel}>
        <img className={style.labelFolderIcon} src={folderIcon} alt="" />
        {labelNmae}
      </span>
    );
  };

  const onNodeSelect = (a: any, b: any) => {
    setNewPath(b);
    setRootActive(false);
  };

  const handleRoot = () => {
    setNewPath("/");
    setRootActive(true);
  };

  const moveFileSubmitloading = false;

  const idFunc = (item: any) => {
    return `${item.dir.substr(1)}${item.name}`;
  };

  return (
    <MyDialog
      handleSubmit={handleMoveFileSubmit}
      onRef={moveFileDialogRef}
      title="移动至"
      submitloading={moveFileSubmitloading}
    >
      <div
        className={classNames({
          [style.rootTitle]: true,
          [style.rootTitleActive]: rootActive,
        })}
        onClick={handleRoot}
      >
        <img className={style.bigFolderIcon} src={bigFolderIcon} alt="" />
        ProjectData
      </div>
      <MyTreeView
        treeData={treeData}
        renderLabel={renderLabel}
        onNodeSelect={onNodeSelect}
        idFunc={idFunc}
        treeViewSx={{
          width: 400,
          overflow: "hidden",
        }}
      ></MyTreeView>
    </MyDialog>
  );
};

export default MoveFile;
