
import { memo, useCallback, useEffect, useMemo, useState } from "react";
import styles from "../index.module.css";
import { Box, Typography } from "@mui/material";
import Button from "@mui/material/Button";
import usePass from "@/hooks/usePass";

const TemplateBox = (props: any) => {
    const info = props.data
    const isPass = usePass();

    return (
        <Box className={styles.templateBlock} >
            <Box>
                <Typography sx={{ fontSize: '14px', fontWeight: '600', color: '#1E2633', marginBottom: "4px", overflow: 'hidden', textOverflow: 'ellipsis' }}>{info.title}</Typography>
                <Box sx={{ display: 'flex', marginBottom: "8px" }}  >
                    <Typography sx={{ fontSize: '12px', fontWeight: '400', color: '#1370FF', marginRight: "24px" }}>版本：{info.version}</Typography>
                    <Typography sx={{ fontSize: '12px', fontWeight: '400', color: '#1370FF' }}>更新时间：{info.updateTime}</Typography>
                </Box>
                <Typography className={styles.templateDescText} >{info.description}</Typography>
            </Box>
            <Box sx={{
                display: 'flex', justifyContent: 'end'
            }} >
                {
                    isPass("PROJECT_WORKBENCH_FLOES_USE", 'MANAGER') && <Button
                        style={{ backgroundColor: "#F0F2F5", color: "#565C66" }}
                        variant="contained"
                        onClick={() => { props.startDialog(info.id) }}
                        size="small"
                    >
                        删除模版
                    </Button>
                }
                {
                    isPass("PROJECT_WORKBENCH_FLOES_USE", 'USER') && <Button
                        style={{ backgroundColor: "#1370FF", marginLeft: "12px" }}
                        variant="contained"
                        // onClick={addTemplateBlock}
                        size="small"
                    >
                        使用模版
                    </Button>
                }
            </Box>
        </Box>
    );
};

export default memo(TemplateBox);
