import smallLogo from "@/assets/project/projectIconSmall.svg";
import style from "./index.module.css";
import { InputBase, IconButton } from "@mui/material";
import SearchIcon from "@mui/icons-material/Search";
import AddIcon from "@mui/icons-material/Add";
import { useStores } from "@/store/index";
import moment from "moment";
import React, { useMemo, useState } from "react";
import { toJS } from "mobx";
import { observer } from "mobx-react-lite";

const ProjectListPopper = observer((props: any) => {
  const { handleChangeCurrentProject, handleClickOpen } = props;
  const { currentProjectStore } = useStores();
  const [name, setName] = useState("");
  const nameChange = (e: any) => {
    setName(e.target.value);
  };

  const list = useMemo(() => {
    return toJS(currentProjectStore.projectList).filter((item: any) => {
      return item.name?.indexOf(name) !== -1;
    });
  }, [currentProjectStore.projectList, name]);

  const handleProjectBox = (e: React.SyntheticEvent) => {
    e.nativeEvent.stopImmediatePropagation();
  }

  return (
    <div className={style.projectBox} onClick={handleProjectBox}>
      <div className={style.searchBox}>
        <IconButton
          type="submit"
          className={style.searchButton}
          aria-label="search"
        >
          <SearchIcon className={style.searchIcon} />
        </IconButton>
        <InputBase
          className={style.searchInput}
          placeholder="请输入项目名称"
          inputProps={{ "aria-label": "请输入项目名称" }}
          value={name}
          onChange={nameChange}
        />
        <IconButton
          onClick={handleClickOpen}
          type="submit"
          className={style.add}
          aria-label="search"
        >
          <AddIcon className={style.addIcon} />
        </IconButton>
      </div>
      <div className={style.projectlist}>
        {list.map((item: any) => {
          return (
            <div
              className={style.projectli}
              key={item.id}
              onClick={() => handleChangeCurrentProject(item)}
            >
              <div className={style.projectliBorderBox}>
                <img src={smallLogo} alt="" className={style.projectliLogo} />
                <div className={style.projectliInfo}>
                  <div className={style.projectName}>{item.name}</div>
                  <div className={style.projectOwnerTime}>
                    <span className={style.projectOwner}>{item.owner}</span>
                    <span className={style.projectTime}>
                      {moment(item.createdAt).format("YYYY-MM-DD")}
                    </span>
                  </div>
                </div>
              </div>
            </div>
          );
        })}
      </div>
    </div>
  );
});

export default ProjectListPopper;
