import request from "@/utils/axios/service";
import Api from "./api_manager";

function current() {
  return request({
    url: Api.API_USER_FETCH,
    method: "get",
  });
}

function menu() {
  return request({
    url: "/accounts/menu-mock",
    method: "get",
  });
}

type projectListParams = {
  product: string;
  name?: string;
};

// 查询当前用户可以看到的项目列表
const product = (params: projectListParams) => {
  return request({
    url: Api.API_PROJECT_LIST,
    method: "get",
    params,
  });
};

type addProjectParams = {
  product: string;
  name: string;
  zoneId: string;
  desc?: string;
};
// 新增项目
const addProject = (params: addProjectParams) => {
  console.log("params", params);
  return request({
    url: Api.API_PROJECT_ADD,
    method: "post",
    data: params,
  });
};

// 获取计算区列表
const hpczone = () => {
  return request({
    url: Api.API_CPCE_HPCZONE,
    method: "get",
  });
};

export { current, menu, product, hpczone, addProject };
