import React from "react";
import PropTypes from "prop-types";
import makeStyles from "@material-ui/styles/makeStyles";
import { Typography, Button, Menu, MenuItem } from "@material-ui/core";
import ArrowDropDownIcon from '@material-ui/icons/ArrowDropDown';
import CheckboxComponent from "@/commons/components/Material.Ui/Checkbox"
import Text from "@/commons/components/Material.Ui/Text"
import { isEn } from "@/commons/utils/helper";

const useStyles = makeStyles({
    root: { backgroundColor: "#136EFA", boxShadow: "none !important", color: "#ffffff", "&:hover": { backgroundColor: "#0055D9" } },
    containedSecondary: { backgroundColor: "#D62C1F", boxShadow: "none !important", "&:hover": { backgroundColor: "#D82C1F" } },
    outlined: { backgroundColor: '#FFFFFF', border: "1px solid #136EFA", boxShadow: "none !important", color: "#136EFA", "&:hover": { backgroundColor: "rgba(19, 110, 250, 0.1)" } },
    outlinedSecondary: { border: "1px solid #D62C1F", color: "#D62C1F", "&:hover": { border: "1px solid #D62C1F", backgroundColor: "rgba(214, 44, 31, 0.1)" } },
    label: { "& p": { fontSize: "13px" } },
    text: { backgroundColor: 'transparent', boxShadow: "none !important" },
    textPrimary: { color: "#136EFA", "&:hover": { backgroundColor: "#E8F1FF" } },
    textSecondary: { color: "#F44335", "&:hover": { backgroundColor: "rgba(244, 67, 53, 0.1)" } },
    sizeSmall: { "& p": { fontSize: "12px" } },
    sizeLarge: { "& p": { fontSize: "14px" } },
    menuItemRoot: { width: "110px" },
    textStyle: { padding: "8px 22px", borderRight: "1px solid rgb(0,44,112,0.2)" },
    textStyle_en: { padding: "8px 16px", borderRight: "1px solid rgb(0,44,112,0.2)" },
    checkBoxBody: { width: "100%", marginLeft: "0px" }

})

const ButtonComponent = (props) => {
    const classes = useStyles();
    const { subText, Checked, selectCallBack, text, size, click, variant, color, disabled, disableElevation, disableFocusRipple, btnStyle = {}, fontSize, subClick } = props;
    const [anchorEl, setAnchorEl] = React.useState(null);
    const defultClick = (event) => event && event.stoppropagation && event.stoppropagation()
    // 更多按钮 点击 弹出菜单
    const handleClick = (event) => {
        console.log(event.currentTarget, 'lllll')
        setAnchorEl(event.currentTarget)

    }
    // 关闭更多 menu 弹框
    const handleClose = () => setAnchorEl(null);
    // 选择更多按钮回调
    const handleCloseOption = (item, key) => {
        setAnchorEl(null);
        selectCallBack && selectCallBack(item, key)
    };
    return (
        <>
            <Button
                size={size || "medium"}
                variant={variant || "contained"}
                color={color || "primary"}
                disabled={disabled || false}
                disableElevation={disableElevation || false}
                disableFocusRipple={disableFocusRipple || false}
                classes={{
                    root: btnStyle.root || classes.root,
                    label: btnStyle.label || classes.label,
                    disabled: btnStyle.disabled || classes.disabled,
                    containedSecondary: btnStyle.containedSecondary || classes.containedSecondary,
                    outlined: btnStyle.outlined || classes.outlined,
                    outlinedSecondary: btnStyle.outlinedSecondary || classes.outlinedSecondary,
                    text: btnStyle.text || classes.text,
                    textPrimary: btnStyle.textPrimary || classes.textPrimary,
                    textSecondary: btnStyle.textSecondary || classes.textSecondary,
                    sizeSmall: btnStyle.sizeSmall || classes.sizeSmall,
                    sizeLarge: btnStyle.sizeLarge || classes.sizeLarge,
                }}
                style={{ ...props.style, boxShadow: "none !important", backgroundColor: "#136EFA", padding: "0px 0px", width: "110px" }}
            >
                <Typography
                    className={isEn() ? classes.textStyle_en : classes.textStyle}
                    style={fontSize ? { fontSize: fontSize } : {}}
                    onClick={click}
                >
                    {text || ""}</Typography>
                <div
                    style={{ display: "flex", padding: "0px 5px" }}
                    onClick={handleClick}
                >
                    <ArrowDropDownIcon fontSize={"small"} style={{ color: "#fff" }} />
                </div>
            </Button>
            <Menu
                id="simple-menu"
                anchorEl={anchorEl}
                keepMounted
                open={Boolean(anchorEl)}
                onClose={handleClose}
                style={{ marginTop: "47px", marginLeft: isEn() ? "-77px" : "-76px" }}
            >
                <div style={{ width: "110px" }}>
                    <CheckboxComponent
                        defaultChecked={Checked}
                        label={<Text text={subText} op={"lg"} variant={"body1"} />}
                        labelPlacement={"end"}
                        size={"small"}
                        checkChange={(event) => subClick(event)}
                        checkBoxStyle={{
                            root: classes.checkBoxBody
                        }}
                    />
                </div>
            </Menu>
        </>
    )
}

ButtonComponent.propTypes = {
    size: PropTypes.oneOf(["large", "medium", "small"]),
    variant: PropTypes.oneOf(["contained", "outlined", "text"]),
    color: PropTypes.oneOf(["default", "inherit", "primary", "secondary"]),
    disabled: PropTypes.bool,
    disableElevation: PropTypes.bool,
    disableFocusRipple: PropTypes.bool,
};
export default ButtonComponent;