import {
  Button,
  Dialog,
  DialogActions,
  DialogContent,
  IconButton,
  DialogTitle,
} from "@mui/material";
import LoadingButton from "@mui/lab/LoadingButton";
import CloseIcon from "@mui/icons-material/Close";

import { useState } from "react";
import React, { useImperativeHandle } from "react";
// import LoadingButton from '@mui/lab/LoadingButton';
const MyDialog = (props: any) => {
  const [open, setOpen] = useState(false);
  const { title, handleSubmit, submitloading } = props;

  const handleClickOpen = () => {
    setOpen(true);
  };

  const handleClose = () => {
    setOpen(false);
  };

  useImperativeHandle(props.onRef, () => {
    return {
      handleClickOpen: handleClickOpen,
      handleClose: handleClose,
    };
  });

  return (
    <Dialog
      open={open}
      onClose={handleClose}
      aria-labelledby="form-dialog-title"
    >
      {title && <DialogTitle id="form-dialog-title">{title}</DialogTitle>}
      <DialogContent>
        {props.children}
        <IconButton
          aria-label="delete"
          style={{ position: "absolute", top: "10px", right: "12px" }}
          onClick={handleClose}
        >
          <CloseIcon style={{ color: "#C2C6CC" }} />
        </IconButton>
      </DialogContent>
      <DialogActions style={{ padding: "24px" }}>
        <Button
          onClick={handleClose}
          color="inherit"
          variant="contained"
          style={{ color: "#1E2633", backgroundColor: "#fff" }}
        >
          取消
        </Button>
        <LoadingButton
          loading={submitloading}
          onClick={handleSubmit}
          color="primary"
          variant="contained"
          style={{ backgroundColor: "#1370FF" }}
        >
          确认
        </LoadingButton>
      </DialogActions>
    </Dialog>
  );
};

export default MyDialog;
