import { Box, List } from "@mui/material";
// import CurrentProject from "./CurrentProject";
import CurrentProject from "../Project/components/CurrentProject";
import React from "react";
import { Outlet, useNavigate } from "react-router-dom";
import style from "./index.module.css";
import { observer } from "mobx-react-lite";
import { useStores } from "@/store/index";
import { toJS } from "mobx";
import classnames from "classnames";

const MenuLayout = observer(() => {
  const { permissionStore } = useStores();
  console.log("11111111111111111111", toJS(permissionStore));
  console.log("11111111111111111111", toJS(permissionStore.sidebarRouters));

  console.log(new URL(window.location.href));
  console.log(new URL(window.location.href).pathname);
  let pathname = new URL(window.location.href).pathname;

  const navigate = useNavigate();

  return (
    <Box className={style.container}>
      <Box className={style.aside}>
        <CurrentProject />
        <List className={style.list}>
          {permissionStore.sidebarRouters.map((item, index) => {
            return (
              <li
                key={"sidebar" + index}
                // className={style.listItem}
                className={classnames({
                  [style.listItem]: true,
                  [style.active]: item.path === pathname,
                })}
                onClick={() => item.type === "page" && navigate(item.path)}
              >
                {item.name}
              </li>

              // <ListItem key={"sidebar" + index} className={style.listItem}>
              //   <ListItemButton
              //     onClick={() => item.type === "page" && navigate(item.path)}
              //   >
              //     <ListItemText>{item.name}</ListItemText>
              //   </ListItemButton>
              // </ListItem>
            );
          })}
        </List>
      </Box>
      <Box className={style.content}>
        <Outlet></Outlet>
      </Box>
    </Box>
  );
});

export default MenuLayout;
