/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-05-31 10:18:13
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-04 18:33:02
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { memo, useEffect, useState } from "react";

import { Box } from "@mui/material";
import Button from "@mui/material/Button";
import SearchIcon from "@mui/icons-material/Search";
import Add from "@mui/icons-material/Add";
import Table from "@/components/Material.Ui/Table";
import { useHttp } from "@/api/http";
import Input from "@/components/Material.Ui/Input";
import RemoveItem from "./components/RemoveItem";
import ChangePermission from "./components/ChangePermission";
import AddMember from "./components/AddMember";

import styles from "./index.module.css";
const ProjectMembers = () => {
  const http = useHttp();

  const columns = [
    { id: "username", label: "成员名称", width: "20%" },
    { id: "projectRoleDesc", label: "项目权限", width: "20%" },
    { id: "phone", label: "联系方式", width: "20%" },
    {
      id: "operation",
      label: "操作",
      width: "20%",
      render: (item: any) => {
        console.log(item, "000000");
        return (
          <>
            <span
              style={{ color: "#1370FF", cursor: "pointer" }}
              onClick={onPermissionBtn}
            >
              更改权限
            </span>
            <span className={styles.removeItemBox} onClick={onRemoveItemBtn}>
              移出项目
            </span>
          </>
        );
      },
    },
  ];

  /** 删除成员 */
  const [removeDialog, setRemoveDialog] = useState<boolean>(false);
  /** 更改权限 */
  const [permissionDialog, setPermissionDialog] = useState<boolean>(false);
  /** 添加成员 */
  const [addMemberDialog, setAddMemberDialog] = useState<boolean>(false);

  useEffect(() => {
    http
      .get("/cpp/project/list", {
        params: { product: "cadd" },
      })
      .then((res) => {
        console.log(res);
      });
  }, [http]);

  /** 点击添加成员 */
  const onAddMember = () => {
    setAddMemberDialog(true);
  };

  /** 点击删除成员 */
  const onRemoveItemBtn = () => {
    setRemoveDialog(true);
  };

  /** 点击更改权限 */
  const onPermissionBtn = () => {
    setPermissionDialog(true);
  };

  return (
    <>
      <Box className={styles.headerBox}>
        <Input
          onChange={(e: any) => {
            console.log(e);
          }}
          size="xsmall"
          placeholder="搜索项目成员"
          endAdornment={<SearchIcon />}
        />
        <Button
          variant="contained"
          onClick={onAddMember}
          startIcon={<Add />}
          size="small"
        >
          添加成员
        </Button>
      </Box>
      <Table
        rowHover={true}
        stickyheader={true}
        rows={[
          {
            username: "wuyongs",
            phone: 2323424,
          },
        ]}
        rowsPerPage={"99"}
        headCells={columns}
        nopadding={true}
        footer={false}
        tableStyle={{ minWidth: "auto" }}
        borderBottom={"none"}
      />
      <RemoveItem
        removeDialog={removeDialog}
        setRemoveDialog={setRemoveDialog}
      />
      <ChangePermission
        permissionDialog={permissionDialog}
        setPermissionDialog={setPermissionDialog}
      />
      <AddMember
        addMemberDialog={addMemberDialog}
        setAddMemberDialog={setAddMemberDialog}
      />
    </>
  );
};

export default memo(ProjectMembers);
