import logo from "@/assets/project/projectIcon.svg";
import style from "./index.module.css";
import ArrowForwardIosIcon from "@mui/icons-material/ArrowForwardIos";
import { Popper, Fade } from "@mui/material";
import { useStores } from "@/store/index";
import ProjectListPopper from "../ProjectListPopper";
import { useState } from "react";
import { observer } from "mobx-react-lite";

const CurrentProject = observer(() => {
  const { currentProjectStore } = useStores();
  const [open, setOpen] = useState(false);
  const [anchorEl, setAnchorEl] = useState<null | HTMLElement>(null);
  const handleShowProjectList = (event: React.MouseEvent<HTMLElement>) => {
    setAnchorEl(event.currentTarget);
    setOpen((previousOpen) => !previousOpen);
  };
  const canBeOpen = open && Boolean(anchorEl);
  const id = canBeOpen ? "spring-popper" : undefined;
  const handleChangeCurrentProject = (project: any) => {
    currentProjectStore.changeProject(project);
    setOpen(!open);
  };

  return (
    <div>
      <div
        className={style.currentProject}
        aria-describedby={id}
        onClick={handleShowProjectList}
      >
        <img src={logo} alt="" className={style.logo} />
        <div className={style.info}>
          <div className={style.name}>
            {currentProjectStore.currentProductInfo.name || "CADD"}
          </div>
          <div className={style.desc}>
            {currentProjectStore.currentProjectInfo.name || "暂无项目"}
          </div>
        </div>
        <ArrowForwardIosIcon
          className={style.showProjectList}
          style={{ fontSize: 12 }}
        />
      </div>
      <Popper
        id={id}
        open={open}
        anchorEl={anchorEl}
        placement="right-start"
        transition
      >
        {({ TransitionProps }) => (
          <Fade {...TransitionProps} timeout={350}>
            <div>
              <ProjectListPopper
                handleChangeCurrentProject={handleChangeCurrentProject}
              />
            </div>
          </Fade>
        )}
      </Popper>
    </div>
  );
});

export default CurrentProject;
