import { OutlinedInput } from "@mui/material";
import SearchIcon from "@mui/icons-material/Search";
import classNames from "classnames";
import { useCallback, useEffect, useState } from "react";
import { observer } from "mobx-react-lite";
import { toJS } from "mobx";
import cloneDeep from "lodash/cloneDeep";

import { mockData } from "./mock";
import { IOperatorItemProps, IOperatorListProps } from "./interface";
import { ITask } from "@/views/Project/ProjectSubmitWork/interface";
import useMyRequest from "@/hooks/useMyRequest";
import { IResponse } from "@/api/http";
import { fetchOperatorList } from "@/api/workbench_api";
import { useStores } from "@/store";
import { uuid } from "@/utils/util";

import styles from "./index.module.css";

/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-07-06 15:16:01
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-07 15:48:12
 * @FilePath: /bkunyun/src/views/WorkFlowEdit/components/OperatorList/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
const OperatorItem = (props: IOperatorItemProps) => {
	const {
		info: { title, description, tags },
		setTemplateConfigInfo,
		templateConfigInfo,
	} = props;
	const [isDragStyle, setIsDragStyle] = useState<boolean>(false);

	/** 拖拽开始 */
	const onDragStart = useCallback(() => {
		setIsDragStyle(true);
	}, []);

	/** 拖拽结束 */
	const onDragEnd = useCallback(
		(e: React.DragEvent<HTMLDivElement>) => {
			const dom = document.getElementById("workFlowEditRight");
			const upperLeftPointX = Number(dom?.offsetLeft);
			const upperLeftPointY = Number(dom?.offsetTop);
			const lowerRightX = Number(upperLeftPointX) + Number(dom?.offsetWidth);
			const lowerRightY = Number(upperLeftPointY) + Number(dom?.offsetHeight);
			if (
				e.clientX > upperLeftPointX &&
				e.clientY > upperLeftPointY &&
				e.clientX < lowerRightX &&
				e.clientY < lowerRightY
			) {
				const newVal = [
					...cloneDeep(templateConfigInfo),
					{ ...props.info, uuid: uuid() },
				];
				setTemplateConfigInfo(newVal);
			}
			setIsDragStyle(false);
		},
		[setTemplateConfigInfo, templateConfigInfo]
	);

	return (
		<div
			className={classNames({
				[styles.operatorItemBox]: true,
				[styles.dragBox]: isDragStyle,
			})}
			draggable={true}
			onDragStart={onDragStart}
			onDragEnd={onDragEnd}
		>
			<h2 className={styles.operatorItemTitle}>{title}</h2>
			<div className={styles.operatorItemText}>{description}</div>
			<div className={styles.footerBox}>
				{tags?.map((item: string) => {
					return (
						<span
							key={item}
							className={styles.labelBox}
							style={{
								background: true ? "#EBF3FF" : "#E3FAEC",
								color: true ? "#1370FF" : "#02AB83",
							}}
						>
							{item}
						</span>
					);
				})}
				{/* <MySelect options={[]} /> */}
			</div>
		</div>
	);
};

const OperatorList = observer((props: IOperatorListProps) => {
	const { currentProjectStore } = useStores();
	const productId = toJS(currentProjectStore.currentProductInfo.id);

	const { templateConfigInfo, setTemplateConfigInfo } = props;

	const [operatorListData, setOperatorListData] = useState<ITask[]>(
		mockData as any
	);

	console.log(templateConfigInfo, "templateConfigInfo");
	// 取消作业
	const { run } = useMyRequest(fetchOperatorList, {
		onSuccess: (res: IResponse<any>) => {
			console.log(res, "1111");
		},
	});

	useEffect(() => {
		run({
			owner: "root",
			productId: "cadd" || "",
			// keyword	: ''
		});
	}, [productId, run]);

	return (
		<div className={styles.operatorListBox}>
			<div className={styles.searchBox}>
				<OutlinedInput
					onChange={(e: any) => {
						console.log(e.target.value);
					}}
					placeholder="输入关键词搜索"
					size="small"
					sx={{ height: 32, width: "100%" }}
					endAdornment={<SearchIcon style={{ color: "#8A9099" }} />}
				/>
			</div>
			<div className={styles.listBox}>
				{operatorListData
					.filter((item) => item.type === "BATCH")
					.map((item) => {
						return (
							<OperatorItem
								key={item.id}
								info={item}
								templateConfigInfo={templateConfigInfo}
								setTemplateConfigInfo={setTemplateConfigInfo}
							/>
						);
					})}
			</div>
		</div>
	);
});

export default OperatorList;
