/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-21 20:03:56
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-08 09:25:42
 * @FilePath: /bkunyun/src/views/Project/ProjectSubmitWork/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import React, { useState } from "react";
import ArrowBackIosNewIcon from "@mui/icons-material/ArrowBackIosNew";
import IconButton from "@mui/material/IconButton";

import MyPopconfirm from "@/components/mui/MyPopconfirm";
import RadioGroupOfButtonStyle from "@/components/CommonComponents/RadioGroupOfButtonStyle";
import ButtonComponent from "@/components/mui/Button";
import OperatorList from "./components/OperatorList";
import Flow from "../Project/components/Flow";
import { ITask } from "../Project/ProjectSubmitWork/interface";

import styles from "./index.module.css";
import { style } from "@mui/system";

const radioOptions = [
	{
		value: "list",
		label: "算子列表",
	},
	{
		value: "setting",
		label: "参数设置",
	},
];

interface IProps {
	onBack?: () => void;
}

const WorkFlowEdit = (props: IProps) => {
	const { onBack } = props;
	const [templateConfigInfo, setTemplateConfigInfo] = useState<ITask[]>([]);

	const [leftContentType, setLeftContentType] = useState("list");

	return (
		<div className={styles.swBox}>
			<div className={styles.swHeader}>
				<div className={styles.swHeaderLeft}>
					<MyPopconfirm
						title="返回后，当前页面已填写内容将不保存，确认返回吗？"
						onConfirm={onBack}
					>
						<IconButton
							color="primary"
							aria-label="upload picture"
							component="span"
							size="small"
						>
							<ArrowBackIosNewIcon
								sx={{
									color: "rgba(194, 198, 204, 1)",
									width: "12px",
									height: "12px",
								}}
							/>
						</IconButton>
					</MyPopconfirm>
				</div>
				<div className={styles.swHeaderRight}>
					<MyPopconfirm
						title="提交前请先确认参数填写无误，确认提交吗？"
						onConfirm={() => console.log(2)}
					>
						<ButtonComponent
							text="保存"
							// click={handleSubmitForm}
						></ButtonComponent>
					</MyPopconfirm>
				</div>
			</div>
			<div className={styles.swContent}>
				<div>
					<div className={styles.radiosBox}>
						<RadioGroupOfButtonStyle
							radioOptions={radioOptions}
							value={leftContentType}
							handleRadio={setLeftContentType}
							RadiosBoxStyle={{
								height: "36px",
								padding: "3px",
							}}
							radioStyle={{
								fontSize: "16px",
								height: "30px",
							}}
						></RadioGroupOfButtonStyle>
					</div>
					{leftContentType === "list" && (
						<div className={styles.swFormBox}>
							<OperatorList
								templateConfigInfo={templateConfigInfo}
								setTemplateConfigInfo={setTemplateConfigInfo}
							/>
						</div>
					)}
					{leftContentType !== "list" && (
						<div className={styles.swFormBox} id="workFlowEditRight">
							<Flow tasks={templateConfigInfo} />
						</div>
					)}
				</div>
			</div>
		</div>
	);
};

export default WorkFlowEdit;
