import MyDialog from "../mui/Dialog";
import { useStores } from "@/store";
import { observer } from "mobx-react-lite";
import { toJS } from "mobx";
import { useEffect, useState } from "react";
import CloudEController from "@/api/fileserver/CloudEController";
import MyTreeView from "@/components/mui/MyTreeView";
import classNames from "classnames";
import bigFolderIcon from "@/assets/project/bigFolderIcon.svg";
import folderIcon from "@/assets/project/folderIcon.svg";
import style from "./index.module.css";

type FileSelectProps = {
  open: boolean;
  onConfirm: any;
  onClose: any;
};

const FileSelect = observer((props: FileSelectProps) => {
  const { onConfirm } = props;
  const { currentProjectStore } = useStores();
  const projectId = toJS(currentProjectStore.currentProjectInfo.id);
  const fileToken = toJS(currentProjectStore.currentProjectInfo.filetoken);
  const [treeData, setTreeData] = useState<Array<any>>([]);
  const [rootActive, setRootActive] = useState(true);
  const [newPath, setNewPath] = useState("/");

  useEffect(() => {
    if (fileToken && projectId) {
      CloudEController.JobOutFileDirtree(
        "/",
        fileToken,
        projectId,
        false
      )?.then((res: any) => {
        if (Array.isArray(res.data)) {
          setTreeData(res.data);
        } else {
          setTreeData([]);
        }
      });
    }
  }, [projectId, fileToken]);

  const renderLabel = (labelNmae: string) => {
    return (
      <span className={style.treeLabel}>
        <img className={style.labelFolderIcon} src={folderIcon} alt="" />
        <span className={style.treeLabelText}>{labelNmae}</span>
      </span>
    );
  };

  const handleRoot = () => {
    setNewPath("/");
    setRootActive(true);
  };

  const onNodeSelect = (a: any, b: any) => {
    setNewPath(b);
    setRootActive(false);
  };

  // 给路径去掉第一个'/'然后结尾加上文件名 方便后面直接使用
  const idFunc = (item: any) => {
    return `${item.dir.substr(1)}${item.name}`;
  };

  const fileSelectOnConfirm = () => {
    onConfirm(newPath);
  };

  return (
    <MyDialog
      open={props.open}
      onClose={props.onClose}
      onConfirm={fileSelectOnConfirm}
    >
      <div
        className={classNames({
          [style.rootTitle]: true,
          [style.rootTitleActive]: rootActive,
        })}
        onClick={handleRoot}
      >
        <img className={style.bigFolderIcon} src={bigFolderIcon} alt="" />
        ProjectData
      </div>
      <MyTreeView
        treeData={treeData}
        renderLabel={renderLabel}
        onNodeSelect={onNodeSelect}
        idFunc={idFunc}
        treeViewSx={{
          width: 400,
          overflow: "hidden",
        }}
      ></MyTreeView>
    </MyDialog>
  );
});

export default FileSelect;
