import * as React from "react";
import { ReactNode } from "react";
import Box from "@mui/material/Box";
import ButtonComponent from "./Button";
import Popper from "@mui/material/Popper";

type IMyPopconfirmProps = {
  title: string | ReactNode;
  cancelText?: string;
  okText?: string;
  showCancel?: boolean;
  onCancel?: any;
  onConfirm?: any;
  children: ReactNode;
};

const MyPopconfirm = (props: IMyPopconfirmProps) => {
  const {
    title,
    cancelText = "取消",
    okText = "确认",
    showCancel = true,
    onCancel,
    onConfirm,
  } = props;

  const [anchorEl, setAnchorEl] = React.useState<null | HTMLElement>(null);

  const handleClick = (event: React.MouseEvent<HTMLElement>) => {
    console.log(123);
    setAnchorEl(anchorEl ? null : event.currentTarget);
  };

  const open = Boolean(anchorEl);
  const id = open ? "simple-popper" : undefined;

  const handleCancel = () => {
    setAnchorEl(null);
    onCancel && onCancel();
  };

  const handleOk = () => {
    setAnchorEl(null);
    onConfirm && onConfirm();
  };

  return (
    <div>
      <div aria-describedby={id} onClick={handleClick}>
        {props.children && props.children}
      </div>
      <Popper
        id={id}
        open={open}
        anchorEl={anchorEl}
        sx={{
          zIndex: 2000,
          bgcolor: "#fff",
          width: "200px",
          borderRadius: "2px",
          padding: "16px 16px 8px",
          boxShadow:
            "0 3px 6px -4px #0000001f, 0 6px 16px #00000014, 0 9px 28px 8px #0000000d",
        }}
      >
        <Box sx={{ marginBottom: "8px" }}>{title}</Box>
        <Box sx={{ display: "flex", justifyContent: "flex-end" }}>
          {showCancel && (
            <ButtonComponent
              text={cancelText}
              variant="text"
              size="small"
              color="secondary"
              click={handleCancel}
            ></ButtonComponent>
          )}
          <ButtonComponent
            text={okText}
            variant="text"
            size="small"
            click={handleOk}
          ></ButtonComponent>
        </Box>
      </Popper>
    </div>
  );
};

export default MyPopconfirm;
