/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-21 20:03:56
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-28 17:19:15
 * @FilePath: /bkunyun/src/views/Project/ProjectSubmitWork/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { useEffect, useState, useMemo } from "react";
import ButtonComponent from "@/components/mui/Button";
import ArrowBackIosNewIcon from "@mui/icons-material/ArrowBackIosNew";
import IconButton from "@mui/material/IconButton";
import useMyRequest from "@/hooks/useMyRequest";
import { fetchWorkFlowJob, getworkFlowTaskInfo } from "@/api/project_api";
import { useLocation, useNavigate } from "react-router-dom";
import { IResponse } from "@/api/http";
import jobSue from "@/assets/project/jobSue.svg";
import jobStop from "@/assets/project/jobStop.svg";
import jobRun from "@/assets/project/jobRun.svg";
import jobFail from "@/assets/project/jobFail.svg";
import classNames from "classnames";

import styles from "./index.module.css";
import { ITaskInfo } from "../ProjectSubmitWork/interface";
import Flow from "../components/Flow";
import { style } from "@mui/system";

const stateMap = {
  RUNNING: "正在运行",
  ABORTED: "运行终止",
  FAILED: "运行失败",
  SUCCEEDED: "运行成功",
};

const statusMap = {
  Done: "运行完成",
  Running: "正在运行",
  Failed: "运行失败",
  Pending: "等待运行",
};

type IStatus = "Done" | "Running" | "Failed" | "Pending";

const ProjectSubmitWork = () => {
  const [workFlowJobInfo, setWorkFlowJobInfo] = useState<ITaskInfo>();
  const [patchInfo, setPatchInfo] = useState<any>();
  const [activePatchId, setActivePatchId] = useState<string>("");
  const [overviewActive, setOverviewActive] = useState(true);
  const [activeFlowIndex, setActiveFlowIndex] = useState<number>(0);
  const [showOptions, setShowOptions] = useState<boolean>(false);
  const location: any = useLocation();
  const navigate = useNavigate();

  /** 获取模版数据 */
  const { run } = useMyRequest(fetchWorkFlowJob, {
    onSuccess: (res: IResponse<ITaskInfo>) => {
      setWorkFlowJobInfo(res.data);
    },
  });

  useEffect(() => {
    const locationInfo: any = location?.state;
    run({
      // id: locationInfo.taskId,
      id: "89a00e93-8bba-45ee-85b0-63c5cd42c570",
    });
  }, [location?.state, run]);

  const { run: getworkFlowTaskInfoRun } = useMyRequest(getworkFlowTaskInfo, {
    onSuccess: (res) => {
      console.log(res);
      setPatchInfo(res.data);
    },
  });

  const handleBatch = (id: string) => {
    setActivePatchId(id);
    if (id) {
      setActiveFlowIndex(0);
      getworkFlowTaskInfoRun({
        jobId: workFlowJobInfo?.id as string,
        taskId: id,
      });
    }
  };

  const randerParameters = useMemo(() => {
    if (patchInfo?.children) {
      if (patchInfo.children.length > 0) {
        return patchInfo.children[activeFlowIndex].parameters;
      } else {
        return patchInfo?.parameters;
      }
    } else {
      return patchInfo?.parameters;
    }
  }, [activeFlowIndex, patchInfo]);

  const handleParams = () => {
    setOverviewActive(false);
    setShowOptions(!showOptions);
  };

  return (
    <div className={styles.swBox}>
      <div className={styles.swHeader}>
        <div className={styles.swHeaderLeft}>
          <IconButton
            color="primary"
            onClick={() => navigate(-1)}
            aria-label="upload picture"
            component="span"
            size="small"
          >
            <ArrowBackIosNewIcon
              sx={{
                color: "rgba(194, 198, 204, 1)",
                width: "12px",
                height: "12px",
              }}
            />
          </IconButton>

          <div className={styles.swTemplateTitle}>{workFlowJobInfo?.name}</div>
        </div>
        <div className={styles.swHeaderRight}>
          <ButtonComponent
            text="终止"
            variant="outlined"
            color="secondary"
          ></ButtonComponent>
        </div>
      </div>
      <div className={styles.swContent}>
        <div className={styles.swFormBox}>
          {!activePatchId && (
            <div className={styles.taskInfo}>
              <div className={styles.title}>任务结果</div>
              <div className={styles.taskResults}>任务结果</div>
              <div className={styles.notResults}>暂无结果文件</div>
              <div className={styles.title}>任务信息</div>
              <div className={styles.taskInfoLi}>
                <div className={styles.taskInfoParams}>任务名称</div>
                <div
                  className={styles.taskInfoValue}
                  title={workFlowJobInfo?.name}
                >
                  {workFlowJobInfo?.name || "-"}
                </div>
              </div>
              <div className={styles.taskInfoLi}>
                <div className={styles.taskInfoParams}>任务ID</div>
                <div
                  className={styles.taskInfoValue}
                  title={workFlowJobInfo?.id}
                >
                  {workFlowJobInfo?.id || "-"}
                </div>
              </div>
              <div className={styles.taskInfoLi}>
                <div className={styles.taskInfoParams}>输出路径</div>
                <div className={styles.taskInfoValue}>
                  {workFlowJobInfo?.outputPath || "-"}
                </div>
              </div>
              <div className={styles.taskInfoLi}>
                <div className={styles.taskInfoParams}>运行状态</div>
                <div className={styles.taskInfoValue}>
                  {workFlowJobInfo?.state === "SUCCEEDED" && (
                    <img
                      className={styles.taskInfoValueIcon}
                      src={jobSue}
                      alt=""
                    />
                  )}
                  {workFlowJobInfo?.state === "RUNNING" && (
                    <img
                      className={styles.taskInfoValueIcon}
                      src={jobRun}
                      alt=""
                    />
                  )}
                  {workFlowJobInfo?.state === "ABORTED" && (
                    <img
                      className={styles.taskInfoValueIcon}
                      src={jobStop}
                      alt=""
                    />
                  )}
                  {workFlowJobInfo?.state === "FAILED" && (
                    <img
                      className={styles.taskInfoValueIcon}
                      src={jobFail}
                      alt=""
                    />
                  )}
                  {workFlowJobInfo?.state
                    ? stateMap[workFlowJobInfo?.state]
                    : "-"}
                </div>
              </div>
              <div className={styles.taskInfoLi}>
                <div className={styles.taskInfoParams}>源模板</div>
                <div className={styles.taskInfoValue}>
                  {workFlowJobInfo?.specTitle || "-"}
                </div>
              </div>
              <div className={styles.taskInfoLi}>
                <div className={styles.taskInfoParams}>源模板版本</div>
                <div className={styles.taskInfoValue}>
                  {workFlowJobInfo?.specVersion || "-"}
                </div>
              </div>
              <div className={styles.taskInfoLi}>
                <div className={styles.taskInfoParams}>花费（元）</div>
                <div className={styles.taskInfoValue}>
                  {workFlowJobInfo?.jobCost || "-"}
                </div>
              </div>
              <div className={styles.taskInfoLi}>
                <div className={styles.taskInfoParams}>创建人</div>
                <div className={styles.taskInfoValue}>
                  {workFlowJobInfo?.creator || "-"}
                </div>
              </div>
              <div className={styles.taskInfoLi}>
                <div className={styles.taskInfoParams}>创建时间</div>
                <div className={styles.taskInfoValue}>
                  {workFlowJobInfo?.createTime || "-"}
                </div>
              </div>
              <div className={styles.taskInfoLi}>
                <div className={styles.taskInfoParams}>运行时间</div>
                <div className={styles.taskInfoValue}>
                  {workFlowJobInfo?.costTime || "-"}
                </div>
              </div>
              <div className={styles.taskInfoLi}>
                <div className={styles.taskInfoParams}>日志文件</div>
                <div className={styles.taskInfoValue}>
                  {workFlowJobInfo?.logPath}
                </div>
              </div>
            </div>
          )}
          {activePatchId && (
            <div className={styles.suanziInfo}>
              <div className={styles.title}>{patchInfo?.title}</div>
              <div className={styles.tabs}>
                <div
                  className={classNames({
                    [styles.tabLi]: true,
                    [styles.tabLiAcitve]: overviewActive,
                  })}
                  onClick={() => setOverviewActive(true)}
                >
                  概览
                </div>
                <div
                  className={classNames({
                    [styles.tabLi]: true,
                    [styles.tabLiAcitve]: !overviewActive,
                  })}
                  // onClick={() => setOverviewActive(false)}
                  onClick={() => handleParams()}
                >
                  {patchInfo?.children.length > 0
                    ? patchInfo?.children[activeFlowIndex].title
                    : patchInfo?.title}
                  {showOptions && patchInfo?.children.length > 0 && (
                    <div className={styles.options}>
                      {patchInfo?.children.map((item: any, index: number) => {
                        return (
                          <div
                            key={index}
                            className={styles.option}
                            onClick={() => setActiveFlowIndex(index)}
                          >
                            {item.title}
                          </div>
                        );
                      })}
                    </div>
                  )}
                </div>
              </div>
              {overviewActive && (
                <div className={styles.overview}>
                  <div className={styles.taskInfoLi}>
                    <div className={styles.taskInfoParams}>描述</div>
                    <div
                      className={classNames({
                        [styles.taskInfoValue]: true,
                        [styles.taskInfoValueShowAll]: true,
                      })}
                    >
                      {patchInfo?.description}
                    </div>
                  </div>
                  <div className={styles.taskInfoLi}>
                    <div className={styles.taskInfoParams}>算子版本</div>
                    <div className={styles.taskInfoValue}>
                      {patchInfo?.creator || "-"}
                    </div>
                  </div>
                  <div className={styles.taskInfoLi}>
                    <div className={styles.taskInfoParams}>算子状态</div>
                    <div className={styles.taskInfoValue}>
                      {patchInfo?.status === "Done" && (
                        <img
                          className={styles.taskInfoValueIcon}
                          src={jobSue}
                          alt=""
                        />
                      )}
                      {patchInfo?.status === "Running" && (
                        <img
                          className={styles.taskInfoValueIcon}
                          src={jobRun}
                          alt=""
                        />
                      )}
                      {patchInfo?.status === "Failed" && (
                        <img
                          className={styles.taskInfoValueIcon}
                          src={jobFail}
                          alt=""
                        />
                      )}
                      {statusMap[patchInfo?.status as IStatus]}
                    </div>
                  </div>
                </div>
              )}
              {!overviewActive && (
                <div className={styles.params}>
                  {randerParameters.map((parameter: any) => {
                    return (
                      <div className={styles.taskInfoLi} key={parameter.name}>
                        <div className={styles.taskInfoParams}>
                          {parameter.name}
                        </div>
                        <div className={styles.taskInfoValue}>
                          {parameter.value || "-"}
                        </div>
                      </div>
                    );
                  })}
                </div>
              )}
            </div>
          )}
        </div>
        <div className={styles.swFlowBox}>
          <Flow tasks={workFlowJobInfo?.tasks} onBatchClick={handleBatch} />
        </div>
      </div>
    </div>
  );
};

export default ProjectSubmitWork;
