import logo from "@/assets/project/projectIcon.svg";
import style from "./index.module.css";
import ArrowForwardIosIcon from "@mui/icons-material/ArrowForwardIos";
import { Popper, Fade } from "@mui/material";
import { useStores } from "@/store/index";
import ProjectListPopper from "../ProjectListPopper";
import { useState } from "react";

const CurrentProject = () => {
  const { currentProjectStore } = useStores();
  const [open, setOpen] = useState(false);
  const [anchorEl, setAnchorEl] = useState(null);
  const handleShowProjectList = (e: any) => {
    setOpen(!open);
    setAnchorEl(anchorEl ? null : e.currentTarget);
  };
  const id = open ? "spring-popper" : undefined;

  return (
    <div>
      <div
        className={style.currentProject}
        aria-describedby="projectList"
        onClick={handleShowProjectList}
      >
        <img src={logo} alt="" className={style.logo} />
        <div className={style.info}>
          <div className={style.name}>
            {currentProjectStore.currentProductInfo.name || "CADD"}
          </div>
          <div className={style.desc}>
            {currentProjectStore.currentProjectInfo.name || "暂无项目"}
          </div>
        </div>
        <ArrowForwardIosIcon
          className={style.showProjectList}
          style={{ fontSize: 12 }}
        />
      </div>
      <Popper
        id={id}
        open={open}
        anchorEl={anchorEl}
        placement="right-start"
        transition
      >
        {({ TransitionProps }) => (
          <Fade {...TransitionProps} timeout={350}>
            <div>
              <ProjectListPopper />
            </div>
          </Fade>
        )}
      </Popper>
    </div>
  );
};

export default CurrentProject;
